/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomFeed;
import com.splunk.Entity;
import com.splunk.Job;
import com.splunk.JobCollection;
import com.splunk.ResponseMessage;
import com.splunk.SavedSearchDispatchArgs;
import com.splunk.Service;
import java.util.Date;
import java.util.Map;

public class SavedSearch
extends Entity {
    SavedSearch(Service service, String path) {
        super(service, path);
    }

    public void acknowledge() {
        this.service.post(this.actionPath("acknowledge"));
        this.invalidate();
    }

    @Override
    protected String actionPath(String action) {
        if (action.equals("acknowledge")) {
            return String.valueOf(this.path) + "/acknowledge";
        }
        if (action.equals("dispatch")) {
            return String.valueOf(this.path) + "/dispatch";
        }
        if (action.equals("history")) {
            return String.valueOf(this.path) + "/history";
        }
        return super.actionPath(action);
    }

    public Job dispatch() throws InterruptedException {
        return this.dispatch(null);
    }

    public Job dispatch(Map args) throws InterruptedException {
        ResponseMessage response = this.service.post(this.actionPath("dispatch"), args);
        this.invalidate();
        String sid = Job.getSid(response);
        JobCollection jobs = this.service.getJobs();
        Job job = (Job)jobs.get(sid);
        if (job == null) {
            job = new Job(this.service, "search/jobs/" + sid);
        }
        return job;
    }

    public Job dispatch(SavedSearchDispatchArgs args) throws InterruptedException {
        return this.dispatch((Map)args);
    }

    public Job[] history() {
        AtomFeed feed;
        ResponseMessage response = this.service.get(this.actionPath("history"));
        try {
            feed = AtomFeed.parseStream(response.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int count = feed.entries.size();
        Job[] result = new Job[count];
        int i = 0;
        while (i < count) {
            String sid = feed.entries.get((int)i).title;
            result[i] = new Job(this.service, "search/jobs/" + sid);
            ++i;
        }
        return result;
    }

    public String getActionEmailAuthPassword() {
        return this.getString("action.email.auth_password", null);
    }

    public String getActionEmailAuthUsername() {
        return this.getString("action.email.auth_username", null);
    }

    public String getActionEmailBcc() {
        return this.getString("action.email.bcc", null);
    }

    public String getActionEmailCc() {
        return this.getString("action.email.cc", null);
    }

    public String getActionEmailCommand() {
        return this.getString("action.email.command", null);
    }

    public String getActionEmailFormat() {
        return this.getString("action.email.format", null);
    }

    public String getActionEmailFrom() {
        return this.getString("action.email.from", null);
    }

    public String getActionEmailHostname() {
        return this.getString("action.email.hostname", null);
    }

    public boolean getActionEmailInline() {
        return this.getBoolean("action.email.inline", false);
    }

    public String getActionEmailMailServer() {
        return this.getString("action.email.mailserver", null);
    }

    public int getActionEmailMaxResults() {
        return this.getInteger("action.email.maxresults", -1);
    }

    public String getActionEmailMaxTime() {
        return this.getString("action.email.maxtime", null);
    }

    public String getActionEmailPdfView() {
        return this.getString("action.email.pdfview", null);
    }

    public String getActionEmailPreProcessResults() {
        return this.getString("action.email.preprocess_results", null);
    }

    public String getActionEmailReportPaperOrientation() {
        return this.getString("action.email.reportPaperOrientation", null);
    }

    public String getActionEmailReportPaperSize() {
        return this.getString("action.email.reportPaperSize", null);
    }

    public boolean getActionEmailReportServerEnabled() {
        return this.getBoolean("action.email.reportServerEnabled", false);
    }

    public String getActionEmailReportServerUrl() {
        return this.getString("action.email.reportServerURL", null);
    }

    public boolean getActionEmailSendPdf() {
        return this.getBoolean("action.email.sendpdf", false);
    }

    public boolean getActionEmailSendResults() {
        return this.getBoolean("action.email.sendresults", false);
    }

    public String getActionEmailSubject() {
        return this.getString("action.email.subject", null);
    }

    public String getActionEmailTo() {
        return this.getString("action.email.to", null);
    }

    public boolean getActionEmailTrackAlert() {
        return this.getBoolean("action.email.track_alert", false);
    }

    public String getActionEmailTtl() {
        return this.getString("action.email.ttl", null);
    }

    public boolean getActionEmailUseSsl() {
        return this.getBoolean("action.email.use_ssl", false);
    }

    public boolean getActionEmailUseTls() {
        return this.getBoolean("action.email.use_tls", false);
    }

    public boolean getActionEmailWidthSortColumns() {
        return this.getBoolean("action.email.width_sort_columns", false);
    }

    public String getActionPopulateLookupCommand() {
        return this.getString("action.populate_lookup.command", null);
    }

    public String getActionPopulateLookupDest() {
        return this.getString("action.populate_lookup.dest", null);
    }

    public String getActionPopulateLookupHostname() {
        return this.getString("action.populate_lookup.hostname", null);
    }

    public int getActionPopulateLookupMaxResults() {
        return this.getInteger("action.populate_lookup.maxresults", -1);
    }

    public String getActionPopulateLookupMaxTime() {
        return this.getString("action.populate_lookup.maxtime", null);
    }

    public boolean getActionPopulateLookupTrackAlert() {
        return this.getBoolean("action.populate_lookup.track_alert", false);
    }

    public String getActionPopulateLookupTtl() {
        return this.getString("action.populate_lookup.ttl", null);
    }

    public String getActionRssCommand() {
        return this.getString("action.rss.command", null);
    }

    public String getActionRssHostname() {
        return this.getString("action.rss.hostname", null);
    }

    public int getActionRssMaxResults() {
        return this.getInteger("action.rss.maxresults", -1);
    }

    public String getActionRssMaxTime() {
        return this.getString("action.rss.maxtime", null);
    }

    public boolean getActionRssTrackAlert() {
        return this.getBoolean("action.rss.track_alert", false);
    }

    public String getActionRssTtl() {
        return this.getString("action.rss.ttl", null);
    }

    public String getActionScriptCommand() {
        return this.getString("action.script.command", null);
    }

    public String getActionScriptFilename() {
        return this.getString("action.script.filename", null);
    }

    public String getActionScriptHostname() {
        return this.getString("action.script.hostname", null);
    }

    public int getActionScriptMaxResults() {
        return this.getInteger("action.script.maxresults", -1);
    }

    public String getActionScriptMaxTime() {
        return this.getString("action.script.maxtime", null);
    }

    public boolean getActionScriptTrackAlert() {
        return this.getBoolean("action.script.track_alert", false);
    }

    public String getActionScriptTtl() {
        return this.getString("action.script.ttl", null);
    }

    public String getActionSummaryIndexName() {
        return this.getString("action.summary_index._name", null);
    }

    public String getActionSummaryIndexCommand() {
        return this.getString("action.summary_index.command", null);
    }

    public String getActionSummaryIndexHostname() {
        return this.getString("action.summary_index.hostname", null);
    }

    public boolean getActionSummaryIndexInline() {
        return this.getBoolean("action.summary_index.inline", false);
    }

    public int getActionSummaryIndexMaxResults() {
        return this.getInteger("action.summary_index.maxresults", -1);
    }

    public String getActionSummaryIndexMaxTime() {
        return this.getString("action.summary_index.maxtime", null);
    }

    public boolean getActionSummaryIndexTrackAlert() {
        return this.getBoolean("action.summary_index.track_alert", false);
    }

    public String getActionSummaryIndexTtl() {
        return this.getString("action.summary_index.ttl", null);
    }

    public boolean getAlertDigestMode() {
        return this.getBoolean("alert.digest_mode", false);
    }

    public String getAlertExpires() {
        return this.getString("alert.expires");
    }

    public int getAlertSeverity() {
        return this.getInteger("alert.severity");
    }

    public boolean getAlertSuppress() {
        return this.getBoolean("alert.suppress", false);
    }

    public String getAlertSuppressFields() {
        return this.getString("alert.suppress.fields", null);
    }

    public String getAlertSuppressPeriod() {
        return this.getString("alert.suppress.period", null);
    }

    public String getAlertTrack() {
        return this.getString("alert.track");
    }

    public String getAlertComparator() {
        return this.getString("alert_comparator", null);
    }

    public String getAlertCondition() {
        return this.getString("alert_condition", null);
    }

    public String getAlertThreshold() {
        return this.getString("alert_threshold", null);
    }

    public String getAlertType() {
        return this.getString("alert_type");
    }

    public String getCronSchedule() {
        return this.getString("cron_schedule", null);
    }

    public String getDescription() {
        return this.getString("description", null);
    }

    public int getDispatchBuckets() {
        return this.getInteger("dispatch.buckets");
    }

    public String getDispatchEarliestTime() {
        return this.getString("dispatch.earliest_time", null);
    }

    public String getDispatchLatestTime() {
        return this.getString("dispatch.latest_time", null);
    }

    public boolean getDispatchLookups() {
        return this.getBoolean("dispatch.lookups");
    }

    public int getDispatchMaxCount() {
        return this.getInteger("dispatch.max_count");
    }

    public int getDispatchMaxTime() {
        return this.getInteger("dispatch.max_time");
    }

    public int getDispatchReduceFrequency() {
        return this.getInteger("dispatch.reduce_freq");
    }

    public boolean getDispatchRtBackfill() {
        return this.getDispatchRealTimeBackfill();
    }

    public boolean getDispatchRealTimeBackfill() {
        return this.getBoolean("dispatch.rt_backfill", false);
    }

    public boolean getDispatchSpawnProcess() {
        return this.getBoolean("dispatch.spawn_process");
    }

    public String getDispatchTimeFormat() {
        return this.getString("dispatch.time_format");
    }

    public String getDispatchTtl() {
        return this.getString("dispatch.ttl");
    }

    public String getDisplayView() {
        return this.getString("displayview", null);
    }

    public int getMaxConcurrent() {
        return this.getInteger("max_concurrent");
    }

    public Date getNextScheduledTime() {
        return this.getDate("next_scheduled_time", null);
    }

    public String getQualifiedSearch() {
        return this.getString("qualifiedSearch", null);
    }

    public boolean getRealtimeSchedule() {
        return this.getBoolean("realtime_schedule");
    }

    public String getRequestUiDispatchApp() {
        return this.getString("request.ui_dispatch_app", null);
    }

    public String getRequestUiDispatchView() {
        return this.getString("request.ui_dispatch_view", null);
    }

    public boolean getRestartOnSearchPeerAdd() {
        return this.getBoolean("restart_on_searchpeer_add");
    }

    public boolean getRunOnStartup() {
        return this.getBoolean("run_on_startup");
    }

    public String getSearch() {
        return this.getString("search");
    }

    public String getVsid() {
        return this.getString("vsid", null);
    }

    public boolean isActionEmail() {
        return this.getBoolean("action.email");
    }

    public boolean isActionPopulateLookup() {
        return this.getBoolean("action.populate_lookup");
    }

    public boolean isActionRss() {
        return this.getBoolean("action.rss");
    }

    public boolean isActionScript() {
        return this.getBoolean("action.script");
    }

    public boolean isActionSummaryIndex() {
        return this.getBoolean("action.summary_index");
    }

    public boolean isDigestMode() {
        return this.getBoolean("alert.digest_mode");
    }

    public boolean isScheduled() {
        return this.getBoolean("is_scheduled");
    }

    public boolean isVisible() {
        return this.getBoolean("is_visible");
    }

    public void setActionEmailAuthPassword(String password) {
        this.setCacheValue("action.email.auth_password", password);
    }

    public void setActionEmailAuthUsername(String username) {
        this.setCacheValue("action.email.auth_username", username);
    }

    public void setActionEmailBcc(String bcc) {
        this.setCacheValue("action.email.bcc", bcc);
    }

    public void setActionEmailCc(String cc) {
        this.setCacheValue("action.email.cc", cc);
    }

    public void setActionEmailCommand(String command) {
        this.setCacheValue("action.email.command", command);
    }

    public void setActionEmailFormat(String format) {
        this.setCacheValue("action.email.format", format);
    }

    public void setActionEmailFrom(String from) {
        this.setCacheValue("action.email.from", from);
    }

    public void setActionEmailHostname(String hostname) {
        this.setCacheValue("action.email.hostname", hostname);
    }

    public void setActionEmailInline(boolean inline) {
        this.setCacheValue("action.email.inline", inline);
    }

    public void setActionEmailMailServer(String mailServer) {
        this.setCacheValue("action.email.mailserver", mailServer);
    }

    public void setActionEmailMaxResults(int maxResults) {
        this.setCacheValue("action.email.maxresults", maxResults);
    }

    public void setActionEmailMaxTime(String maxTime) {
        this.setCacheValue("action.email.maxtime", maxTime);
    }

    public void setActionEmailPdfView(String name) {
        this.setCacheValue("action.email.pdfview", name);
    }

    public void setActionEmailPreProcessResults(String preprocess) {
        this.setCacheValue("action.email.preprocess_results", preprocess);
    }

    public void setActionEmailReportPaperOrientation(String orientation) {
        this.setCacheValue("action.email.reportPaperOrientation", orientation);
    }

    public void setActionEmailReportPaperSize(String size) {
        this.setCacheValue("action.email.reportPaperSize", size);
    }

    public void setActionEmailReportServerEnabled(boolean pdfServerEnabled) {
        this.setCacheValue("action.email.reportServerEnabled", pdfServerEnabled);
    }

    public void setActionEmailReportServerUrl(String pdfServerUrl) {
        this.setCacheValue("action.email.reportServerURL", pdfServerUrl);
    }

    public void setActionEmailSendPdf(boolean sendPdf) {
        this.setCacheValue("action.email.sendpdf", sendPdf);
    }

    public void setActionEmailSendResults(boolean sendResults) {
        this.setCacheValue("action.email.sendresults", sendResults);
    }

    public void setActionEmailSubject(String subject) {
        this.setCacheValue("action.email.subject", subject);
    }

    public void setActionEmailTo(String to) {
        this.setCacheValue("action.email.to", to);
    }

    public void setActionEmailTrackAlert(boolean trackAlert) {
        this.setCacheValue("action.email.track_alert", trackAlert);
    }

    public void setActionEmailTtl(String ttl) {
        this.setCacheValue("action.email.ttl", ttl);
    }

    public void setActionEmailUseSsl(boolean useSsl) {
        this.setCacheValue("action.email.use_ssl", useSsl);
    }

    public void setActionEmailUseTls(boolean useTls) {
        this.setCacheValue("action.email.use_tls", useTls);
    }

    public void setActionEmailWidthSortColumns(boolean widthSortColumns) {
        this.setCacheValue("action.email.width_sort_columns", widthSortColumns);
    }

    public void setActionPopulateLookupCommand(String command) {
        this.setCacheValue("action.populate_lookup.command", command);
    }

    public void setActionPopulateLookupDest(String dest) {
        this.setCacheValue("action.populate_lookup.dest", dest);
    }

    public void setActionPopulateLookupHostname(String hostname) {
        this.setCacheValue("action.populate_lookup.hostname", hostname);
    }

    public void setActionPopulateLookupMaxResults(int maxResults) {
        this.setCacheValue("action.populate_lookup.maxresults", maxResults);
    }

    public void setActionPopulateLookupMaxTime(String maxTime) {
        this.setCacheValue("action.populate_lookup.maxtime", maxTime);
    }

    public void setActionPopulateLookupTrackAlert(boolean trackAlert) {
        this.setCacheValue("action.populate_lookup.track_alert", trackAlert);
    }

    public void setActionPopulateLookupTtl(String ttl) {
        this.setCacheValue("action.populate_lookup.ttl", ttl);
    }

    public void setActionRssCommand(String command) {
        this.setCacheValue("action.rss.command", command);
    }

    public void setActionRssHostname(String hostname) {
        this.setCacheValue("action.rss.hostname", hostname);
    }

    public void setActionRssMaxResults(int maxResults) {
        this.setCacheValue("action.rss.maxresults", maxResults);
    }

    public void setActionRssMaxTime(String maxTime) {
        this.setCacheValue("action.rss.maxtime", maxTime);
    }

    public void setActionRssTrackAlert(boolean trackAlert) {
        this.setCacheValue("action.rss.track_alert", trackAlert);
    }

    public void setActionRssTtl(String ttl) {
        this.setCacheValue("action.rss.ttl", ttl);
    }

    public void setActionScriptCommand(String command) {
        this.setCacheValue("action.script.command", command);
    }

    public void setActionScriptFilename(String filename) {
        this.setCacheValue("action.script.filename", filename);
    }

    public void setActionScriptHostname(String hostname) {
        this.setCacheValue("action.script.hostname", hostname);
    }

    public void setActionScriptMaxResults(int maxResults) {
        this.setCacheValue("action.script.maxresults", maxResults);
    }

    public void setActionScriptMaxTime(String maxTime) {
        this.setCacheValue("action.script.maxtime", maxTime);
    }

    public void setActionScriptTrackAlert(boolean trackAlert) {
        this.setCacheValue("action.script.track_alert", trackAlert);
    }

    public void setActionScriptTtl(String ttl) {
        this.setCacheValue("action.script.ttl", ttl);
    }

    public void setActionSummaryIndexName(String name) {
        this.setCacheValue("action.summary_index._name", name);
    }

    public void setActionSummaryIndexCommand(String command) {
        this.setCacheValue("action.summary_index.command", command);
    }

    public void setActionSummaryIndexHostname(String hostname) {
        this.setCacheValue("action.summary_index.hostname", hostname);
    }

    public void setActionSummaryIndexInline(boolean inline) {
        this.setCacheValue("action.summary_index.inline", inline);
    }

    public void setActionSummaryIndexMaxResults(int maxResults) {
        this.setCacheValue("action.summary_index.maxresults", maxResults);
    }

    public void setActionSummaryIndexMaxTime(String maxTime) {
        this.setCacheValue("action.summary_index.maxtime", maxTime);
    }

    public void setActionSummaryIndexTrackAlert(boolean trackAlert) {
        this.setCacheValue("action.summary_index.track_alert", trackAlert);
    }

    public void setActionSummaryIndexTtl(String ttl) {
        this.setCacheValue("action.summary_index.ttl", ttl);
    }

    public void setActions(String actions) {
        this.setCacheValue("actions", actions);
    }

    public void setAlertDigestMode(boolean digest) {
        this.setCacheValue("alert.digest_mode", digest);
    }

    public void setAlertExpires(String period) {
        this.setCacheValue("alert.expires", period);
    }

    public void setAlertSeverity(int severity) {
        this.setCacheValue("alert.severity", severity);
    }

    public void setAlertSuppress(boolean suppress) {
        this.setCacheValue("alert.suppress", suppress);
    }

    public void setAlertSuppressFields(String fields) {
        this.setCacheValue("alert.suppress.fields", fields);
    }

    public void setAlertSuppressPeriod(String period) {
        this.setCacheValue("alert.suppress.period", period);
    }

    public void setAlertTrack(String track) {
        this.setCacheValue("alert.track", track);
    }

    public void setAlertComparator(String comparator) {
        this.setCacheValue("alert_comparator", comparator);
    }

    public void setAlertCondition(String conditional) {
        this.setCacheValue("alert_condition", conditional);
    }

    public void setAlertThreshold(String threshold) {
        this.setCacheValue("alert_threshold", threshold);
    }

    public void setAlertType(String type) {
        this.setCacheValue("alert_type", type);
    }

    public void setCronSchedule(String cronSchedule) {
        this.setCacheValue("cron_schedule", cronSchedule);
    }

    public void setDescription(String description) {
        this.setCacheValue("description", description);
    }

    public void setDisabled(boolean disabled) {
        this.setCacheValue("disabled", disabled);
    }

    public void setDispatchBuckets(String buckets) {
        this.setDispatchBuckets(Integer.parseInt(buckets));
    }

    public void setDispatchBuckets(int buckets) {
        this.setCacheValue("dispatch.buckets", buckets);
    }

    public void setDispatchEarliestTime(String earliestTime) {
        this.setCacheValue("dispatch.earliest_time", earliestTime);
    }

    public void setDispatchLatestTime(String latestTime) {
        this.setCacheValue("dispatch.latest_time", latestTime);
    }

    public void setDispatchLookups(boolean lookups) {
        this.setCacheValue("dispatch.lookups", lookups);
    }

    public void setDispatchMaxCount(int max) {
        this.setCacheValue("dispatch.max_count", max);
    }

    public void setDispatchMaxTime(int max) {
        this.setCacheValue("dispatch.max_time", max);
    }

    public void setDispatchReduceFrequency(int seconds) {
        this.setCacheValue("dispatch.reduce_freq", seconds);
    }

    public void setDispatchRealTimeBackfill(boolean backfill) {
        this.setCacheValue("dispatch.rt_backfill", backfill);
    }

    public void setDispatchSpawnProcess(boolean spawn) {
        this.setCacheValue("dispatch.spawn_process", spawn);
    }

    public void setDispatchTimeFormat(String format) {
        this.setCacheValue("dispatch.time_format", format);
    }

    public void setDispatchTtl(String format) {
        this.setCacheValue("dispatch.ttl", format);
    }

    public void setDisplayView(String view) {
        this.setCacheValue("displayview", view);
    }

    public void setIsScheduled(boolean value) {
        this.setCacheValue("is_scheduled", value);
    }

    public void setIsVisible(boolean value) {
        this.setCacheValue("is_visible", value);
    }

    public void setMaxConcurrent(int max) {
        this.setCacheValue("max_concurrent", max);
    }

    public void setRealtimeSchedule(boolean value) {
        this.setCacheValue("realtime_schedule", value);
    }

    public void setRequestUiDispatchApp(String app) {
        this.setCacheValue("request.ui_dispatch_app", app);
    }

    public void setRequestUiDispatchView(String view) {
        this.setCacheValue("request.ui_dispatch_view", view);
    }

    public void setRestartOnSearchpeerAdd(boolean restart) {
        this.setRestartOnSearchPeerAdd(restart);
    }

    public void setRestartOnSearchPeerAdd(boolean restart) {
        this.setCacheValue("restart_on_searchpeer_add", restart);
    }

    public void setRunOnStartup(boolean startup) {
        this.setCacheValue("run_on_startup", startup);
    }

    public void setSearch(String search) {
        this.setCacheValue("search", search);
    }

    public void setVsid(String vsid) {
        this.setCacheValue("vsid", vsid);
    }

    @Override
    public void update(Map<String, Object> args) {
        if (!args.containsKey("search")) {
            args = Args.create(args).add("search", this.getSearch());
        }
        super.update(args);
    }

    @Override
    public void update() {
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("search")) {
            this.setCacheValue("search", this.getSearch());
        }
        super.update();
    }
}

