/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.SplunkInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;

public class SplunkRawTCPInput
extends SplunkInput {
    private static int SOCKET_BUFFER_SIZE = 8192;
    private String host = "";
    private int port;
    private Socket streamSocket = null;
    private OutputStream ostream;
    private Writer writerOut = null;

    public static int getSocketBufferSize() {
        return SOCKET_BUFFER_SIZE;
    }

    public static void setSocketBufferSize(int n) {
        SOCKET_BUFFER_SIZE = n;
    }

    public SplunkRawTCPInput(String string, int n, String string2) throws Exception {
        this.activationKeyCheck(string2);
        if (this.activated) {
            this.host = string;
            this.port = n;
            this.openStream();
        }
    }

    private void openStream() throws Exception {
        this.streamSocket = new Socket(this.host, this.port);
        if (this.streamSocket.isConnected()) {
            this.streamSocket.setSendBufferSize(SplunkRawTCPInput.getSocketBufferSize());
            this.streamSocket.setReceiveBufferSize(SplunkRawTCPInput.getSocketBufferSize());
            this.ostream = this.streamSocket.getOutputStream();
            this.writerOut = new OutputStreamWriter(this.ostream, "UTF8");
        }
    }

    public void closeStream() {
        try {
            if (this.writerOut != null) {
                this.writerOut.flush();
                this.writerOut.close();
                if (this.streamSocket != null) {
                    this.streamSocket.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void streamEvent(String string) {
        if (this.activated) {
            String string2 = string;
            try {
                if (this.writerOut != null) {
                    this.writerOut.write(string2 + "\n");
                    while (this.queueContainsEvents()) {
                        String string3;
                        string2 = string3 = this.dequeue();
                        this.writerOut.write(string2 + "\n");
                    }
                    this.writerOut.flush();
                }
            }
            catch (IOException iOException) {
                this.enqueue(string2);
                try {
                    this.closeStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.openStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

