/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.jdk.handler;

import com.splunk.logging.HECTransportConfig;
import com.splunk.logging.SplunkHECInput;
import com.splunk.logging.jdk.handler.SplunkFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SplunkHECHandler
extends Handler {
    private HECTransportConfig config = new HECTransportConfig();
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkHECInput shi;
    private String activationKey;

    public SplunkHECHandler() {
        this.configure();
        try {
            this.shi = new SplunkHECInput(this.config, this.activationKey);
            this.shi.setMaxQueueSize(this.maxQueueSize);
            this.shi.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.activationKey = logManager.getProperty(string + ".activationKey");
        this.config.setHost(logManager.getProperty(string + ".host"));
        this.config.setPort(Integer.parseInt(logManager.getProperty(string + ".port")));
        this.config.setPoolsize(Integer.parseInt(logManager.getProperty(string + ".poolsize")));
        this.config.setHttps(Boolean.parseBoolean(logManager.getProperty(string + ".https")));
        this.config.setToken(logManager.getProperty(string + ".token"));
        this.config.setIndex(logManager.getProperty(string + ".index"));
        this.config.setSource(logManager.getProperty(string + ".source"));
        this.config.setSourcetype(logManager.getProperty(string + ".sourcetype"));
        this.config.setBatchMode(Boolean.parseBoolean(logManager.getProperty(string + ".batchMode")));
        this.config.setMaxBatchSizeBytes(logManager.getProperty(string + ".maxBatchSizeBytes"));
        this.config.setMaxBatchSizeEvents(Long.parseLong(logManager.getProperty(string + ".maxBatchSizeEvents")));
        this.config.setMaxInactiveTimeBeforeBatchFlush(Long.parseLong(logManager.getProperty(string + ".maxInactiveTimeBeforeBatchFlush")));
        this.setMaxQueueSize(logManager.getProperty(string + ".maxQueueSize"));
        this.setDropEventsOnQueueFull(Boolean.parseBoolean(logManager.getProperty(string + ".dropEventsOnQueueFull")));
        this.setLevel(Level.parse(logManager.getProperty(string + ".level")));
        this.setFilter(null);
        this.setFormatter(new SplunkFormatter());
        try {
            this.setEncoding(logManager.getProperty(string + ".encoding"));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.shi != null) {
            try {
                this.shi.closeStream();
                this.shi = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.shi = null;
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.shi == null) {
            return;
        }
        String string = this.getFormatter().format(logRecord);
        this.shi.streamEvent(string);
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }

    @Override
    public void flush() {
    }
}

