/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.jdk.handler;

import com.splunk.logging.RestEventData;
import com.splunk.logging.SplunkRestInput;
import com.splunk.logging.jdk.handler.SplunkFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SplunkRestHandler
extends Handler {
    public static final String STREAM = "stream";
    public static final String SIMPLE = "simple";
    private String user = "";
    private String pass = "";
    private String host = "";
    private int port = 8089;
    private String delivery = "stream";
    private String metaSource = "";
    private String metaSourcetype = "";
    private String metaIndex = "";
    private String metaHostRegex = "";
    private String metaHost = "";
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRestInput sri;
    private RestEventData red = new RestEventData();
    private String activationKey;

    public SplunkRestHandler() {
        this.configure();
        try {
            this.sri = new SplunkRestInput(this.user, this.pass, this.host, this.port, this.red, this.delivery.equals(STREAM), this.activationKey);
            this.sri.setMaxQueueSize(this.maxQueueSize);
            this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.activationKey = logManager.getProperty(string + ".activationKey");
        this.setUser(logManager.getProperty(string + ".user"));
        this.setPass(logManager.getProperty(string + ".pass"));
        this.setHost(logManager.getProperty(string + ".host"));
        this.setDelivery(logManager.getProperty(string + ".delivery"));
        this.setPort(Integer.parseInt(logManager.getProperty(string + ".port")));
        this.setMetaSource(logManager.getProperty(string + ".metaSource"));
        this.setMetaHost(logManager.getProperty(string + ".metaHost"));
        this.setMetaHostRegex(logManager.getProperty(string + ".metaHostRegex"));
        this.setMetaIndex(logManager.getProperty(string + ".metaIndex"));
        this.setMetaSourcetype(logManager.getProperty(string + ".metaSourcetype"));
        this.setMaxQueueSize(logManager.getProperty(string + ".maxQueueSize"));
        this.setDropEventsOnQueueFull(Boolean.parseBoolean(logManager.getProperty(string + ".dropEventsOnQueueFull")));
        this.setLevel(Level.parse(logManager.getProperty(string + ".level")));
        this.setFilter(null);
        this.setFormatter(new SplunkFormatter());
        try {
            this.setEncoding(logManager.getProperty(string + ".encoding"));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.sri == null) {
            return;
        }
        String string = this.getFormatter().format(logRecord);
        if (this.delivery.equals(STREAM)) {
            this.sri.streamEvent(string);
        } else if (this.delivery.equals(SIMPLE)) {
            this.sri.sendEvent(string);
        } else {
            return;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        if (string != null) {
            this.user = string;
        }
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String string) {
        if (string != null) {
            this.pass = string;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        if (string != null) {
            this.host = string;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n > 0) {
            this.port = n;
        }
    }

    public String getDelivery() {
        return this.delivery;
    }

    public void setDelivery(String string) {
        if (string != null) {
            this.delivery = string;
        }
    }

    public String getMetaSource() {
        return this.metaSource;
    }

    public void setMetaSource(String string) {
        if (string != null) {
            this.metaSource = string;
            this.red.setSource(string);
        }
    }

    public String getMetaSourcetype() {
        return this.metaSourcetype;
    }

    public void setMetaSourcetype(String string) {
        if (string != null) {
            this.metaSourcetype = string;
            this.red.setSourcetype(string);
        }
    }

    public String getMetaIndex() {
        return this.metaIndex;
    }

    public void setMetaIndex(String string) {
        if (string != null) {
            this.metaIndex = string;
            this.red.setIndex(string);
        }
    }

    public String getMetaHostRegex() {
        return this.metaHostRegex;
    }

    public void setMetaHostRegex(String string) {
        if (string != null) {
            this.metaHostRegex = string;
            this.red.setHostRegex(string);
        }
    }

    public String getMetaHost() {
        return this.metaHost;
    }

    public void setMetaHost(String string) {
        if (string != null) {
            this.metaHost = string;
            this.red.setHost(string);
        }
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }

    @Override
    public void flush() {
    }
}

