/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.log4j.appender;

import com.splunk.logging.HECTransportConfig;
import com.splunk.logging.SplunkHECInput;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class SplunkHECAppender
extends AppenderSkeleton {
    private HECTransportConfig config = new HECTransportConfig();
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkHECInput shi;
    private String activationKey;

    public SplunkHECAppender() {
    }

    public SplunkHECAppender(Layout layout) {
        this.layout = layout;
    }

    protected void append(LoggingEvent loggingEvent) {
        try {
            if (this.shi == null) {
                this.shi = new SplunkHECInput(this.config, this.activationKey);
                this.shi.setMaxQueueSize(this.maxQueueSize);
                this.shi.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
        }
        catch (Exception exception) {
            this.errorHandler.error("Couldn't establish connection for SplunkHECAppender named \"" + this.name + "\".");
            return;
        }
        String string = this.layout.format(loggingEvent);
        if (this.layout.ignoresThrowable()) {
            String[] stringArray = loggingEvent.getThrowableStrRep();
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(Layout.LINE_SEP);
                    stringBuilder.append(stringArray[i]);
                }
            }
            string = string + stringBuilder.toString();
        }
        this.shi.streamEvent(string);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.shi != null) {
            try {
                this.shi.closeStream();
                this.shi = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.shi = null;
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getToken() {
        return this.config.getToken();
    }

    public void setToken(String string) {
        this.config.setToken(string);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public void setHost(String string) {
        this.config.setHost(string);
    }

    public int getPort() {
        return this.config.getPort();
    }

    public void setPort(int n) {
        this.config.setPort(n);
    }

    public boolean isHttps() {
        return this.config.isHttps();
    }

    public void setHttps(boolean bl) {
        this.config.setHttps(bl);
    }

    public int getPoolsize() {
        return this.config.getPoolsize();
    }

    public void setPoolsize(int n) {
        this.config.setPoolsize(n);
    }

    public String getIndex() {
        return this.config.getIndex();
    }

    public void setIndex(String string) {
        this.config.setIndex(string);
    }

    public String getSource() {
        return this.config.getSource();
    }

    public void setSource(String string) {
        this.config.setSource(string);
    }

    public String getSourcetype() {
        return this.config.getSourcetype();
    }

    public void setSourcetype(String string) {
        this.config.setSourcetype(string);
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public long getMaxBatchSizeEvents() {
        return this.config.getMaxBatchSizeEvents();
    }

    public void setMaxBatchSizeEvents(long l) {
        this.config.setMaxBatchSizeEvents(l);
    }

    public long getMaxInactiveTimeBeforeBatchFlush() {
        return this.config.getMaxInactiveTimeBeforeBatchFlush();
    }

    public void setMaxInactiveTimeBeforeBatchFlush(long l) {
        this.config.setMaxInactiveTimeBeforeBatchFlush(l);
    }

    public boolean isBatchMode() {
        return this.config.isBatchMode();
    }

    public void setBatchMode(boolean bl) {
        this.config.setBatchMode(bl);
    }

    public String getMaxBatchSizeBytes() {
        return String.valueOf(this.config.getMaxBatchSizeBytes());
    }

    public void setMaxBatchSizeBytes(String string) {
        this.config.setMaxBatchSizeBytes(string);
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

