/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.log4j.appender;

import com.splunk.logging.SplunkRawTCPInput;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class SplunkRawTCPAppender
extends AppenderSkeleton {
    private String host = "";
    private int port = 5150;
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRawTCPInput sri;
    private String activationKey;

    public SplunkRawTCPAppender() {
    }

    public SplunkRawTCPAppender(Layout layout) {
        this.layout = layout;
    }

    protected void append(LoggingEvent loggingEvent) {
        try {
            if (this.sri == null) {
                this.sri = new SplunkRawTCPInput(this.host, this.port, this.activationKey);
                this.sri.setMaxQueueSize(this.maxQueueSize);
                this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
        }
        catch (Exception exception) {
            this.errorHandler.error("Couldn't establish Raw TCP connection for SplunkRawTCPAppender named \"" + this.name + "\".");
            return;
        }
        String string = this.layout.format(loggingEvent);
        if (this.layout.ignoresThrowable()) {
            String[] stringArray = loggingEvent.getThrowableStrRep();
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(Layout.LINE_SEP);
                    stringBuilder.append(stringArray[i]);
                }
            }
            string = string + stringBuilder.toString();
        }
        this.sri.streamEvent(string);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

