/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.splunk.logging.HECTransportConfig;
import com.splunk.logging.SplunkHECInput;

public class SplunkHECAppender
extends AppenderBase<ILoggingEvent> {
    private HECTransportConfig config = new HECTransportConfig();
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkHECInput shi;
    private Layout<ILoggingEvent> layout;
    private String activationKey;

    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.shi != null) {
            String string = this.layout.doLayout((Object)iLoggingEvent);
            this.shi.streamEvent(string);
        }
    }

    public void start() {
        if (this.layout == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.shi == null) {
            try {
                this.shi = new SplunkHECInput(this.config, this.activationKey);
                this.shi.setMaxQueueSize(this.maxQueueSize);
                this.shi.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
            catch (Exception exception) {
                this.addError("Couldn't establish connection for SplunkHECAppender named \"" + this.name + "\".");
            }
        }
        super.start();
    }

    public void stop() {
        if (this.shi != null) {
            try {
                this.shi.closeStream();
                this.shi = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.shi = null;
            }
        }
        super.stop();
    }

    public String getToken() {
        return this.config.getToken();
    }

    public void setToken(String string) {
        this.config.setToken(string);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public void setHost(String string) {
        this.config.setHost(string);
    }

    public int getPort() {
        return this.config.getPort();
    }

    public void setPort(int n) {
        this.config.setPort(n);
    }

    public boolean isHttps() {
        return this.config.isHttps();
    }

    public void setHttps(boolean bl) {
        this.config.setHttps(bl);
    }

    public int getPoolsize() {
        return this.config.getPoolsize();
    }

    public void setPoolsize(int n) {
        this.config.setPoolsize(n);
    }

    public String getIndex() {
        return this.config.getIndex();
    }

    public void setIndex(String string) {
        this.config.setIndex(string);
    }

    public String getSource() {
        return this.config.getSource();
    }

    public void setSource(String string) {
        this.config.setSource(string);
    }

    public String getSourcetype() {
        return this.config.getSourcetype();
    }

    public void setSourcetype(String string) {
        this.config.setSourcetype(string);
    }

    public long getMaxBatchSizeEvents() {
        return this.config.getMaxBatchSizeEvents();
    }

    public void setMaxBatchSizeEvents(long l) {
        this.config.setMaxBatchSizeEvents(l);
    }

    public long getMaxInactiveTimeBeforeBatchFlush() {
        return this.config.getMaxInactiveTimeBeforeBatchFlush();
    }

    public void setMaxInactiveTimeBeforeBatchFlush(long l) {
        this.config.setMaxInactiveTimeBeforeBatchFlush(l);
    }

    public boolean isBatchMode() {
        return this.config.isBatchMode();
    }

    public void setBatchMode(boolean bl) {
        this.config.setBatchMode(bl);
    }

    public String getMaxBatchSizeBytes() {
        return String.valueOf(this.config.getMaxBatchSizeBytes());
    }

    public void setMaxBatchSizeBytes(String string) {
        this.config.setMaxBatchSizeBytes(string);
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

