/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.splunk.logging.SplunkRawTCPInput;

public class SplunkRawTCPAppender
extends AppenderBase<ILoggingEvent> {
    private String host = "";
    private int port = 5150;
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRawTCPInput sri;
    private Layout<ILoggingEvent> layout;
    private String activationKey;

    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.sri != null) {
            String string = this.layout.doLayout((Object)iLoggingEvent);
            this.sri.streamEvent(string);
        }
    }

    public void start() {
        if (this.layout == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.sri == null) {
            try {
                this.sri = new SplunkRawTCPInput(this.host, this.port, this.activationKey);
                this.sri.setMaxQueueSize(this.maxQueueSize);
                this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
            catch (Exception exception) {
                this.addError("Couldn't establish Raw TCP connection for SplunkRawTCPAppender named \"" + this.name + "\".");
            }
        }
        super.start();
    }

    public void stop() {
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
        super.stop();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

