/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.splunk.logging.RestEventData;
import com.splunk.logging.SplunkRestInput;

public class SplunkRestAppender
extends AppenderBase<ILoggingEvent> {
    public static final String STREAM = "stream";
    public static final String SIMPLE = "simple";
    private String user = "";
    private String pass = "";
    private String host = "";
    private int port = 8089;
    private String delivery = "stream";
    private String metaSource = "";
    private String metaSourcetype = "";
    private String metaIndex = "";
    private String metaHostRegex = "";
    private String metaHost = "";
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRestInput sri;
    private RestEventData red = new RestEventData();
    private Layout<ILoggingEvent> layout;
    private String activationKey;

    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.sri != null) {
            String string = this.layout.doLayout((Object)iLoggingEvent);
            if (this.delivery.equals(STREAM)) {
                this.sri.streamEvent(string);
            } else if (this.delivery.equals(SIMPLE)) {
                this.sri.sendEvent(string);
            } else {
                this.addError("Unsupported delivery setting for SplunkRestAppender named \"" + this.name + "\".");
                return;
            }
        }
    }

    public void start() {
        if (this.layout == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.sri == null) {
            try {
                this.sri = new SplunkRestInput(this.user, this.pass, this.host, this.port, this.red, this.delivery.equals(STREAM), this.activationKey);
                this.sri.setMaxQueueSize(this.maxQueueSize);
                this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
            catch (Exception exception) {
                this.addError("Couldn't establish REST service for SplunkRestAppender named \"" + this.name + "\".");
            }
        }
        super.start();
    }

    public void stop() {
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
        super.stop();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getDelivery() {
        return this.delivery;
    }

    public void setDelivery(String string) {
        this.delivery = string;
    }

    public String getMetaSource() {
        return this.metaSource;
    }

    public void setMetaSource(String string) {
        this.metaSource = string;
        this.red.setSource(string);
    }

    public String getMetaSourcetype() {
        return this.metaSourcetype;
    }

    public void setMetaSourcetype(String string) {
        this.metaSourcetype = string;
        this.red.setSourcetype(string);
    }

    public String getMetaIndex() {
        return this.metaIndex;
    }

    public void setMetaIndex(String string) {
        this.metaIndex = string;
        this.red.setIndex(string);
    }

    public String getMetaHostRegex() {
        return this.metaHostRegex;
    }

    public void setMetaHostRegex(String string) {
        this.metaHostRegex = string;
        this.red.setHostRegex(string);
    }

    public String getMetaHost() {
        return this.metaHost;
    }

    public void setMetaHost(String string) {
        this.metaHost = string;
        this.red.setHost(string);
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

