/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.Args;
import com.splunk.Receiver;
import com.splunk.Service;
import com.splunk.logging.RestEventData;
import com.splunk.logging.SplunkInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;

public class SplunkRestInput
extends SplunkInput {
    private Service service;
    private Receiver receivers;
    private Args args;
    private String user = "";
    private String pass = "";
    private String host = "";
    private int port;
    private Socket streamSocket = null;
    private OutputStream ostream;
    private Writer writerOut = null;

    public SplunkRestInput(String string, String string2, String string3, int n, RestEventData restEventData, boolean bl, String string4) throws Exception {
        this.activationKeyCheck(string4);
        if (this.activated) {
            this.host = string3;
            this.port = n;
            this.user = string;
            this.pass = string2;
            this.args = this.createArgs(restEventData);
            this.initService();
            if (bl) {
                this.openStream();
            }
        }
    }

    private void initService() {
        System.setProperty("splunk.securetransport.protocol", "tls");
        this.service = new Service(this.host, this.port);
        this.service.login(this.user, this.pass);
        this.receivers = this.service.getReceiver();
    }

    private void openStream() throws Exception {
        if (this.receivers != null) {
            this.streamSocket = this.receivers.attach(this.args);
            this.ostream = this.streamSocket.getOutputStream();
            this.writerOut = new OutputStreamWriter(this.ostream, "UTF8");
        }
    }

    private Args createArgs(RestEventData restEventData) {
        Args args = new Args();
        if (restEventData != null) {
            if (restEventData.getIndex().length() > 0) {
                args.add(RestEventData.RECEIVERS_SIMPLE_ARG_INDEX, (Object)restEventData.getIndex());
            }
            if (restEventData.getSource().length() > 0) {
                args.add(RestEventData.RECEIVERS_SIMPLE_ARG_SOURCE, (Object)restEventData.getSource());
            }
            if (restEventData.getSourcetype().length() > 0) {
                args.add(RestEventData.RECEIVERS_SIMPLE_ARG_SOURCETYPE, (Object)restEventData.getSourcetype());
            }
            if (restEventData.getHost().length() > 0) {
                args.add(RestEventData.RECEIVERS_SIMPLE_ARG_HOST, (Object)restEventData.getHost());
            }
            if (restEventData.getHostRegex().length() > 0) {
                args.add(RestEventData.RECEIVERS_SIMPLE_ARG_HOSTREGEX, (Object)restEventData.getHostRegex());
            }
        }
        return args;
    }

    public void closeStream() {
        try {
            if (this.writerOut != null) {
                this.writerOut.flush();
                this.writerOut.close();
                if (this.streamSocket != null) {
                    this.streamSocket.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendEvent(String string) {
        if (this.activated) {
            String string2 = string;
            try {
                if (this.streamSocket == null) {
                    this.receivers.log(this.args, string2);
                    while (this.queueContainsEvents()) {
                        String string3;
                        string2 = string3 = this.dequeue();
                        this.receivers.log(this.args, string2);
                    }
                }
            }
            catch (Exception exception) {
                this.enqueue(string2);
            }
        }
    }

    public void streamEvent(String string) {
        if (this.activated) {
            String string2 = string;
            try {
                if (this.writerOut != null) {
                    this.writerOut.write(string2 + "\n");
                    while (this.queueContainsEvents()) {
                        String string3;
                        string2 = string3 = this.dequeue();
                        this.writerOut.write(string2 + "\n");
                    }
                    this.writerOut.flush();
                }
            }
            catch (IOException iOException) {
                this.enqueue(string2);
                try {
                    this.closeStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.initService();
                    this.openStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

