/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.jdk.handler;

import com.splunk.logging.SplunkRawTCPInput;
import com.splunk.logging.jdk.handler.SplunkFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SplunkRawTCPHandler
extends Handler {
    private String host = "";
    private int port = 5150;
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRawTCPInput sri;
    private String activationKey;

    public SplunkRawTCPHandler() {
        this.configure();
        try {
            this.sri = new SplunkRawTCPInput(this.host, this.port, this.activationKey);
            this.sri.setMaxQueueSize(this.maxQueueSize);
            this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.activationKey = logManager.getProperty(string + ".activationKey");
        this.setHost(logManager.getProperty(string + ".host"));
        this.setPort(Integer.parseInt(logManager.getProperty(string + ".port")));
        this.setMaxQueueSize(logManager.getProperty(string + ".maxQueueSize"));
        this.setDropEventsOnQueueFull(Boolean.parseBoolean(logManager.getProperty(string + ".dropEventsOnQueueFull")));
        this.setLevel(Level.parse(logManager.getProperty(string + ".level")));
        this.setFilter(null);
        this.setFormatter(new SplunkFormatter());
        try {
            this.setEncoding(logManager.getProperty(string + ".encoding"));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.sri == null) {
            return;
        }
        String string = this.getFormatter().format(logRecord);
        this.sri.streamEvent(string);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        if (string != null) {
            this.host = string;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n > 0) {
            this.port = n;
        }
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }

    @Override
    public void flush() {
    }
}

