/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AtomObject {
    public String id;
    public Map<String, String> links = new HashMap<String, String>();
    public String title;
    public String updated;

    protected static XMLStreamReader createReader(InputStream input) {
        XMLStreamReader reader;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        try {
            reader = factory.createXMLStreamReader(input);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        assert (reader.getEventType() == 7);
        AtomObject.scanTag(reader);
        return reader;
    }

    void init(XMLStreamReader reader) {
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        if (name.equals("id")) {
            this.id = this.parseText(reader);
        } else if (name.equals("link")) {
            String rel = reader.getAttributeValue(null, "rel");
            String href = reader.getAttributeValue(null, "href");
            this.links.put(rel, href);
            this.parseEnd(reader);
        } else if (name.equals("title")) {
            this.title = this.parseText(reader);
        } else if (name.equals("updated")) {
            this.updated = this.parseText(reader);
        } else {
            this.parseEnd(reader);
        }
    }

    void load(XMLStreamReader reader, String localName) {
        assert (AtomObject.isStartElement(reader, localName));
        String name = reader.getLocalName();
        AtomObject.scan(reader);
        while (reader.isStartElement()) {
            this.init(reader);
        }
        if (!AtomObject.isEndElement(reader, name)) {
            AtomObject.syntaxError(reader);
        }
        AtomObject.scan(reader);
    }

    protected void parseEnd(XMLStreamReader reader) {
        AtomObject.scanEnd(reader);
        AtomObject.scan(reader);
    }

    protected String parseText(XMLStreamReader reader) {
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        String value = AtomObject.getElementText(reader);
        if (!AtomObject.isEndElement(reader, name)) {
            AtomObject.syntaxError(reader);
        }
        AtomObject.scan(reader);
        return value;
    }

    protected static String getElementText(XMLStreamReader reader) {
        try {
            return reader.getElementText();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static boolean isEndElement(XMLStreamReader reader, String localName) {
        return reader.isEndElement() && reader.getLocalName().equals(localName);
    }

    protected static boolean isStartElement(XMLStreamReader reader, String localName) {
        return reader.isStartElement() && reader.getLocalName().equals(localName);
    }

    protected static void scan(XMLStreamReader reader) {
        assert (!reader.isWhiteSpace());
        try {
            do {
                reader.next();
            } while (reader.isWhiteSpace());
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static void scanEnd(XMLStreamReader reader) {
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        block5: while (true) {
            AtomObject.scan(reader);
            switch (reader.getEventType()) {
                case 4: {
                    continue block5;
                }
                case 1: {
                    AtomObject.scanEnd(reader);
                    continue block5;
                }
                case 2: {
                    if (!reader.getLocalName().equals(name)) {
                        AtomObject.syntaxError(reader);
                    }
                    return;
                }
            }
            AtomObject.syntaxError(reader);
        }
    }

    protected static void scanTag(XMLStreamReader reader) {
        try {
            reader.nextTag();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static void syntaxError(XMLStreamReader reader) {
        Location location = reader.getLocation();
        String where = location.toString();
        String message = String.format("Syntax error @ %s", where);
        throw new RuntimeException(message);
    }
}

