/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.splunk.DataModel;
import com.splunk.DataModelCalculation;
import com.splunk.DataModelConstraint;
import com.splunk.DataModelField;
import com.splunk.DataModelSearch;
import com.splunk.DataModelTransaction;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.PivotSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataModelObject {
    private DataModel model;
    private String name;
    private String[] lineage;
    private String displayName;
    private String parentName;
    private Map<String, DataModelField> autoextractedFields;
    private Collection<DataModelConstraint> constraints;
    private Map<String, DataModelCalculation> calculations;

    protected DataModelObject(DataModel model) {
        this.model = model;
    }

    public boolean containsField(String fieldName) {
        if (this.autoextractedFields.containsKey(fieldName)) {
            return true;
        }
        for (DataModelCalculation c : this.calculations.values()) {
            if (!c.containsGeneratedField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public Job createLocalAccelerationJob() {
        return this.createLocalAccelerationJob(null);
    }

    public Job createLocalAccelerationJob(String earliestTime) {
        String query = "| datamodel " + this.model.getName() + " " + this.getName() + " search | tscollect";
        JobArgs args = new JobArgs();
        if (earliestTime != null) {
            args.setEarliestTime(earliestTime);
        }
        return this.model.getService().search(query, args);
    }

    public Map<String, DataModelCalculation> getCalculations() {
        return Collections.unmodifiableMap(this.calculations);
    }

    public DataModelCalculation getCalculation(String calculationId) {
        return this.calculations.get(calculationId);
    }

    public Collection<DataModelConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    public DataModel getDataModel() {
        return this.model;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DataModelField getField(String fieldName) {
        if (this.autoextractedFields.containsKey(fieldName)) {
            return this.autoextractedFields.get(fieldName);
        }
        for (DataModelCalculation c : this.calculations.values()) {
            if (!c.containsGeneratedField(fieldName)) continue;
            return c.getGeneratedField(fieldName);
        }
        return null;
    }

    public Collection<DataModelField> getAutoExtractedFields() {
        return Collections.unmodifiableCollection(this.autoextractedFields.values());
    }

    public Collection<DataModelField> getFields() {
        ArrayList<DataModelField> fields = new ArrayList<DataModelField>();
        fields.addAll(this.autoextractedFields.values());
        for (DataModelCalculation c : this.calculations.values()) {
            fields.addAll(c.getGeneratedFields());
        }
        return fields;
    }

    public String getQuery() {
        return "| datamodel " + this.getDataModel().getName() + " " + this.getName() + " search";
    }

    public String getName() {
        return this.name;
    }

    public String[] getLineage() {
        return this.lineage;
    }

    public String getParentName() {
        return this.parentName;
    }

    public DataModelObject getParent() {
        return this.getDataModel().getObject(this.parentName);
    }

    public PivotSpecification createPivotSpecification() {
        return new PivotSpecification(this);
    }

    public Job runQuery() {
        return this.runQuery("", null);
    }

    public Job runQuery(JobArgs args) {
        return this.runQuery("", args);
    }

    public Job runQuery(String querySuffix) {
        return this.runQuery(querySuffix, null);
    }

    public Job runQuery(String querySuffix, JobArgs args) {
        return this.getDataModel().getService().search(String.valueOf(this.getQuery()) + querySuffix, args);
    }

    static DataModelObject parse(DataModel dataModel, JsonElement object) {
        String name = null;
        String displayName = null;
        Object comment = null;
        String[] lineage = new String[]{};
        String parentName = null;
        HashMap<String, DataModelField> fields = new HashMap<String, DataModelField>();
        ArrayList children = new ArrayList();
        ArrayList<DataModelConstraint> constraints = new ArrayList<DataModelConstraint>();
        HashMap<String, DataModelCalculation> calculations = new HashMap<String, DataModelCalculation>();
        String baseSearch = null;
        String transactionMaxPause = null;
        String transactionMaxTimeSpan = null;
        ArrayList<String> groupByFields = new ArrayList<String>();
        ArrayList<String> objectsToGroup = new ArrayList<String>();
        for (Map.Entry entry : object.getAsJsonObject().entrySet()) {
            if (((String)entry.getKey()).equals("objectName")) {
                name = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("displayName")) {
                displayName = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("lineage")) {
                lineage = ((JsonElement)entry.getValue()).getAsString().split("\\.");
                continue;
            }
            if (((String)entry.getKey()).equals("parentName")) {
                parentName = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("fields")) {
                JsonArray fieldsJson = ((JsonElement)entry.getValue()).getAsJsonArray();
                fields.clear();
                for (JsonElement fieldJson : fieldsJson) {
                    DataModelField field = DataModelField.parse(fieldJson);
                    fields.put(field.getName(), field);
                }
                continue;
            }
            if (((String)entry.getKey()).equals("constraints")) {
                JsonArray constraintsJson = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement constraintJson : constraintsJson) {
                    DataModelConstraint constraint = DataModelConstraint.parse(constraintJson);
                    constraints.add(constraint);
                }
                continue;
            }
            if (((String)entry.getKey()).equals("calculations")) {
                calculations.clear();
                for (JsonElement cjson : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    DataModelCalculation c = DataModelCalculation.parse(cjson);
                    String cid = c.getCalculationID();
                    calculations.put(cid, c);
                }
                continue;
            }
            if (((String)entry.getKey()).equals("baseSearch")) {
                baseSearch = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("transactionMaxPause")) {
                transactionMaxPause = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("transactionMaxTimeSpan")) {
                transactionMaxTimeSpan = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equals("groupByFields")) {
                for (JsonElement e : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    groupByFields.add(e.getAsString());
                }
                continue;
            }
            if (!((String)entry.getKey()).equals("objectsToGroup")) continue;
            for (JsonElement e : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                objectsToGroup.add(e.getAsString());
            }
        }
        DataModelObject dmo = baseSearch != null ? new DataModelSearch(dataModel) : (transactionMaxPause != null ? new DataModelTransaction(dataModel) : new DataModelObject(dataModel));
        dmo.name = name;
        dmo.displayName = displayName;
        dmo.lineage = lineage;
        dmo.parentName = parentName;
        dmo.autoextractedFields = fields;
        dmo.constraints = constraints;
        dmo.calculations = calculations;
        if (baseSearch != null) {
            dmo.baseSearch = baseSearch;
        } else if (transactionMaxPause != null) {
            ((DataModelTransaction)dmo).groupByFields = groupByFields;
            ((DataModelTransaction)dmo).objectsToGroup = objectsToGroup;
            ((DataModelTransaction)dmo).maxPause = transactionMaxPause;
            ((DataModelTransaction)dmo).maxSpan = transactionMaxTimeSpan;
        }
        return dmo;
    }
}

