/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    STRING{

        public String toString() {
            return "string";
        }
    }
    ,
    NUMBER{

        public String toString() {
            return "number";
        }
    }
    ,
    BOOLEAN{

        public String toString() {
            return "boolean";
        }
    }
    ,
    IPV4{

        public String toString() {
            return "ipv4";
        }
    }
    ,
    TIMESTAMP{

        public String toString() {
            return "timestamp";
        }
    }
    ,
    CHILDCOUNT{

        public String toString() {
            return "childcount";
        }
    }
    ,
    OBJECTCOUNT{

        public String toString() {
            return "objectcount";
        }
    }
    ,
    UNDEFINED{

        public String toString() {
            throw new UnsupportedOperationException("No serialization for undefined field type.");
        }
    };

    private static final Map<String, FieldType> typeLookup;

    static {
        typeLookup = new HashMap<String, FieldType>(){
            {
                this.put("string", STRING);
                this.put("number", NUMBER);
                this.put("boolean", BOOLEAN);
                this.put("ipv4", IPV4);
                this.put("timestamp", TIMESTAMP);
                this.put("childcount", CHILDCOUNT);
                this.put("objectcount", OBJECTCOUNT);
            }
        };
    }

    private FieldType() {
    }

    public static FieldType parseType(String text) {
        FieldType result = typeLookup.get(text.toLowerCase());
        if (result == null) {
            result = UNDEFINED;
        }
        return result;
    }

    /* synthetic */ FieldType(String string, int n, FieldType fieldType) {
        this();
    }
}

