/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomEntry;
import com.splunk.AtomFeed;
import com.splunk.Resource;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.SplunkException;
import com.splunk.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ResourceCollection<T extends Resource>
extends Resource
implements Map<String, T> {
    protected LinkedHashMap<String, LinkedList<T>> items = new LinkedHashMap();
    protected Class itemClass;
    static Class[] itemSig = new Class[]{Service.class, String.class};

    ResourceCollection(Service service, String path, Class itemClass) {
        super(service, path);
        this.itemClass = itemClass;
    }

    ResourceCollection(Service service, String path, Class itemClass, Args args) {
        super(service, path, args);
        this.itemClass = itemClass;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((ResourceCollection)this.validate()).items.containsKey(key);
    }

    public boolean containsKey(Object key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        this.validate();
        LinkedList<T> entities = this.items.get(key);
        if (entities == null || entities.size() == 0) {
            return false;
        }
        String pathMatcher = this.service.fullpath("", namespace);
        for (Resource entity : entities) {
            if (!entity.path.startsWith(pathMatcher)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(value);
        return ((ResourceCollection)this.validate()).items.containsValue(linkedList);
    }

    protected T createItem(Class itemClass, String path, Args namespace) {
        Resource item;
        Constructor constructor;
        try {
            constructor = itemClass.getDeclaredConstructor(itemSig);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            Object obj = constructor.newInstance(this.service, this.service.fullpath(path, namespace));
            item = (Resource)obj;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        return (T)item;
    }

    protected T createItem(AtomEntry entry) {
        return this.createItem(this.itemClass, this.itemPath(entry), this.namespace(entry));
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return ((ResourceCollection)this.validate()).items.equals(o);
    }

    @Override
    public T get(Object key) {
        this.validate();
        LinkedList<T> entities = this.items.get(key);
        if (entities != null && entities.size() > 1) {
            throw new SplunkException(3, "Key has multiple values, specify a namespace");
        }
        if (entities == null || entities.size() == 0) {
            return null;
        }
        return (T)((Resource)entities.get(0));
    }

    public T get(Object key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        this.validate();
        LinkedList<T> entities = this.items.get(key);
        if (entities == null || entities.size() == 0) {
            return null;
        }
        String pathMatcher = this.service.fullpath("", namespace);
        for (Resource entity : entities) {
            if (!entity.path.startsWith(pathMatcher)) continue;
            return (T)entity;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return ((ResourceCollection)this.validate()).items.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return ((ResourceCollection)this.validate()).items.isEmpty();
    }

    protected String itemKey(AtomEntry entry) {
        return entry.title;
    }

    protected String itemPath(AtomEntry entry) {
        return (String)entry.links.get("alternate");
    }

    private Args namespace(AtomEntry entry) {
        Args namespace = new Args();
        if (entry.content == null) {
            return namespace;
        }
        HashMap entityMetadata = (HashMap)entry.content.get("eai:acl");
        if (entityMetadata.containsKey("owner")) {
            namespace.put("owner", entityMetadata.get("owner"));
        }
        if (entityMetadata.containsKey("app")) {
            namespace.put("app", entityMetadata.get("app"));
        }
        if (entityMetadata.containsKey("sharing")) {
            namespace.put("sharing", entityMetadata.get("sharing"));
        }
        return namespace;
    }

    @Override
    public Set<String> keySet() {
        return ((ResourceCollection)this.validate()).items.keySet();
    }

    public ResponseMessage list() {
        return this.service.get(this.path, this.refreshArgs);
    }

    ResourceCollection<T> load(AtomFeed value) {
        super.load(value);
        for (AtomEntry entry : value.entries) {
            LinkedList<Object> list;
            String key = this.itemKey(entry);
            T item = this.createItem(entry);
            if (this.items.containsKey(key)) {
                list = this.items.get(key);
                list.add(item);
                continue;
            }
            list = new LinkedList<T>();
            list.add(item);
            this.items.put(key, list);
        }
        return this;
    }

    @Override
    public T put(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourceCollection refresh() {
        this.items.clear();
        ResponseMessage response = this.list();
        assert (response.getStatus() == 200);
        AtomFeed feed = null;
        try {
            feed = AtomFeed.parseStream(response.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.load(feed);
        return this;
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return ((ResourceCollection)this.validate()).items.size();
    }

    @Override
    public ResourceCollection<T> validate() {
        super.validate();
        return this;
    }

    @Override
    public Collection<T> values() {
        LinkedList<Resource> collection = new LinkedList<Resource>();
        this.validate();
        Set<String> keySet = this.items.keySet();
        for (String key : keySet) {
            LinkedList<T> list = this.items.get(key);
            for (Resource item : list) {
                collection.add(item);
            }
        }
        return collection;
    }

    public int valueSize(Object key) {
        this.validate();
        LinkedList<T> entities = this.items.get(key);
        if (entities == null || entities.size() == 0) {
            return 0;
        }
        return entities.size();
    }
}

