/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.splunk.Event;
import com.splunk.ResultsReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;

public class ResultsReaderJson
extends ResultsReader {
    private JsonReader jsonReader;
    private ExportHelper exportHelper;
    private boolean previewFlagRead;

    public ResultsReaderJson(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    ResultsReaderJson(InputStream inputStream, boolean isInMultiReader) throws IOException {
        super(inputStream, isInMultiReader);
        this.jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        this.jsonReader.setLenient(true);
        if (this.isExportStream || isInMultiReader) {
            this.exportHelper = new ExportHelper();
        }
        this.finishInitialization();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean advanceIntoNextSetBeforeEvent() throws IOException {
        boolean endPassed;
        block10: {
            if (this.jsonReader == null) {
                return false;
            }
            try {
                if (this.exportHelper != null) {
                    if (this.jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                        throw new UnsupportedOperationException("A stream from an export endpoint of a Splunk 4.x server in the JSON output format is not supported by this class. Use the XML search output format, and an XML result reader instead.");
                    }
                    break block10;
                }
                if (this.jsonReader.peek() != JsonToken.BEGIN_OBJECT) {
                    this.jsonReader.beginArray();
                    return true;
                }
                this.jsonReader.beginObject();
                while (true) {
                    String key;
                    if ((key = this.jsonReader.nextName()).equals("preview")) {
                        this.readPreviewFlag();
                        continue;
                    }
                    if (key.equals("results")) {
                        this.jsonReader.beginArray();
                        return true;
                    }
                    this.skipEntity();
                }
            }
            catch (EOFException e) {
                return false;
            }
        }
        do {
            endPassed = this.exportHelper.lastRow;
            this.exportHelper.skipRestOfRow();
            if (this.exportHelper.readIntoRow()) continue;
            return false;
        } while (!endPassed);
        return true;
    }

    private void readPreviewFlag() throws IOException {
        this.isPreview = this.jsonReader.nextBoolean();
        this.previewFlagRead = true;
    }

    private void skipEntity() throws IOException {
        if (this.jsonReader.peek() == JsonToken.STRING) {
            this.jsonReader.nextString();
        } else if (this.jsonReader.peek() == JsonToken.BOOLEAN) {
            this.jsonReader.nextBoolean();
        } else if (this.jsonReader.peek() == JsonToken.NUMBER) {
            this.jsonReader.nextDouble();
        } else if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
        } else if (this.jsonReader.peek() == JsonToken.NAME) {
            this.jsonReader.nextName();
        } else if (this.jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            this.jsonReader.beginArray();
            while (this.jsonReader.peek() != JsonToken.END_ARRAY) {
                this.skipEntity();
            }
            this.jsonReader.endArray();
        } else if (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
            this.jsonReader.beginObject();
            while (this.jsonReader.peek() != JsonToken.END_OBJECT) {
                this.skipEntity();
            }
            this.jsonReader.endObject();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.jsonReader != null) {
            this.jsonReader.close();
        }
        this.jsonReader = null;
    }

    @Override
    public boolean isPreview() {
        if (!this.previewFlagRead) {
            throw new UnsupportedOperationException("isPreview() is not supported with a stream from a Splunk 4.x server by this class. Use the XML format and an XML result reader instead.");
        }
        return this.isPreview;
    }

    @Override
    public Collection<String> getFields() {
        throw new UnsupportedOperationException("getFields() is not supported by this subclass.");
    }

    @Override
    Event getNextEventInCurrentSet() throws IOException {
        if (this.exportHelper != null) {
            if (this.exportHelper.lastRow && !this.exportHelper.inRow) {
                return null;
            }
            this.exportHelper.readIntoRow();
        }
        Event returnData = this.readEvent();
        if (this.exportHelper != null) {
            this.exportHelper.skipRestOfRow();
            return returnData;
        }
        if (returnData == null) {
            this.close();
        }
        return returnData;
    }

    /*
     * Unable to fully structure code
     */
    private Event readEvent() throws IOException {
        returnData = null;
        name = null;
        values = new ArrayList<String>();
        if (this.jsonReader != null) ** GOTO lbl33
        return null;
lbl-1000:
        // 1 sources

        {
            if (returnData == null) {
                returnData = new Event();
            }
            if (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                this.jsonReader.beginObject();
            }
            if (this.jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                this.jsonReader.beginArray();
                while (this.jsonReader.hasNext()) {
                    jsonToken2 = this.jsonReader.peek();
                    if (jsonToken2 != JsonToken.STRING) continue;
                    values.add(this.jsonReader.nextString());
                }
                this.jsonReader.endArray();
                valuesArray = values.toArray(new String[values.size()]);
                returnData.putArray(name, valuesArray);
                values.clear();
            }
            if (this.jsonReader.peek() == JsonToken.NAME) {
                name = this.jsonReader.nextName();
            }
            if (this.jsonReader.peek() == JsonToken.STRING) {
                delimitedValues = this.jsonReader.nextString();
                returnData.putSingleOrDelimited(name, delimitedValues);
            }
            if (this.jsonReader.peek() == JsonToken.END_OBJECT) {
                this.jsonReader.endObject();
                break;
            }
            if (this.jsonReader.peek() != JsonToken.END_ARRAY) continue;
            this.jsonReader.endArray();
lbl33:
            // 3 sources

            ** while (this.jsonReader.hasNext())
        }
lbl34:
        // 2 sources

        return returnData;
    }

    @Override
    boolean advanceStreamToNextSet() throws IOException {
        return this.advanceIntoNextSetBeforeEvent();
    }

    private class ExportHelper {
        boolean lastRow = true;
        boolean inRow;

        ExportHelper() {
        }

        private boolean readIntoRow() throws IOException {
            if (this.inRow) {
                return true;
            }
            if (ResultsReaderJson.this.jsonReader.peek() == JsonToken.END_DOCUMENT) {
                return false;
            }
            this.inRow = true;
            ResultsReaderJson.this.jsonReader.beginObject();
            this.lastRow = false;
            while (ResultsReaderJson.this.jsonReader.hasNext()) {
                String key = ResultsReaderJson.this.jsonReader.nextName();
                if (key.equals("preview")) {
                    ResultsReaderJson.this.readPreviewFlag();
                    continue;
                }
                if (key.equals("lastrow")) {
                    this.lastRow = ResultsReaderJson.this.jsonReader.nextBoolean();
                    continue;
                }
                if (key.equals("result")) {
                    return true;
                }
                ResultsReaderJson.this.skipEntity();
            }
            return false;
        }

        private void skipRestOfRow() throws IOException {
            if (!this.inRow) {
                return;
            }
            this.inRow = false;
            while (ResultsReaderJson.this.jsonReader.peek() != JsonToken.END_OBJECT) {
                ResultsReaderJson.this.skipEntity();
            }
            ResultsReaderJson.this.jsonReader.endObject();
        }
    }
}

