/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.InputKind;
import com.splunk.PortInput;
import com.splunk.ReceiverBehavior;
import com.splunk.Service;
import com.splunk.TcpConnections;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class TcpInput
extends PortInput {
    TcpInput(Service service, String path) {
        super(service, path);
    }

    public Socket attach() throws IOException {
        return new Socket(this.service.getHost(), this.getPort());
    }

    public void attachWith(ReceiverBehavior behavior) throws IOException {
        Socket socket = null;
        OutputStream output = null;
        try {
            socket = this.attach();
            output = socket.getOutputStream();
            behavior.run(output);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public TcpConnections connections() {
        return new TcpConnections(this.service, String.valueOf(this.path) + "/connections");
    }

    public String getConnectionHost() {
        return this.getString("connection_host", null);
    }

    public String getGroup() {
        return this.getString("group", null);
    }

    public String getHost() {
        return this.getString("host", null);
    }

    public String getIndex() {
        return this.getString("index", null);
    }

    @Override
    public InputKind getKind() {
        return InputKind.Tcp;
    }

    public String getQueue() {
        return this.getString("queue", null);
    }

    public int getRcvBuf() {
        return this.getInteger("_rcvbuf");
    }

    public String getRestrictToHost() {
        return this.getString("restrictToHost", null);
    }

    public String getSource() {
        return this.getString("source", null);
    }

    public String getSourceType() {
        return this.getString("sourcetype", null);
    }

    public boolean getSSL() {
        return this.getBoolean("SSL", false);
    }

    public void setSSL(boolean SSL) {
        this.setCacheValue("SSL", SSL);
    }

    public void setConnectionHost(String connection_host) {
        this.setCacheValue("connection_host", connection_host);
    }

    public void setDisabled(boolean disabled) {
        this.setCacheValue("disabled", disabled);
    }

    public void setHost(String host) {
        this.setCacheValue("host", host);
    }

    public void setIndex(String index) {
        this.setCacheValue("index", index);
    }

    public void submit(String eventBody) throws IOException {
        Socket socket = null;
        OutputStream output = null;
        try {
            socket = this.attach();
            output = socket.getOutputStream();
            output.write(eventBody.getBytes("UTF-8"));
            output.flush();
            output.close();
            socket.close();
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public void setQueue(String queue) {
        this.setCacheValue("queue", queue);
    }

    public void setRawTcpDoneTimeout(int rawTcpDoneTimeout) {
        this.setCacheValue("rawTcpDoneTimeout", rawTcpDoneTimeout);
    }

    public void setSource(String source) {
        this.setCacheValue("source", source);
    }

    public void setSourceType(String sourcetype) {
        this.setCacheValue("sourcetype", sourcetype);
    }
}

