/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class SplunkLogEvent {
    private StringBuffer eventMessage = new StringBuffer();
    private boolean quoteValues = true;
    private boolean useInternalDate = true;
    private static final String KVDELIM = "=";
    private static final String PAIRDELIM = " ";
    private static final char QUOTE = '\"';
    private static final String DATEFORMATPATTERN = "yyyy-MM-dd HH:mm:ss:SSSZ";
    private static FastDateFormat DATEFORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss:SSSZ");
    private static final String PREFIX_NAME = "name";
    private static final String PREFIX_EVENT_ID = "event_id";
    private static final String THROWABLE_CLASS = "throwable_class";
    private static final String THROWABLE_MESSAGE = "throwable_message";
    private static final String THROWABLE_STACKTRACE_ELEMENTS = "stacktrace_elements";
    public static String AC_MANAGEMENT_DEST_NT_DOMAIN = "dest_nt_domain";
    public static String AC_MANAGEMENT_SIGNATURE = "signature";
    public static String AC_MANAGEMENT_SRC_NT_DOMAIN = "src_nt_domain";
    public static String AUTH_ACTION = "action";
    public static String AUTH_APP = "app";
    public static String AUTH_DEST = "dest";
    public static String AUTH_SRC = "src";
    public static String AUTH_SRC_USER = "src_user";
    public static String AUTH_USER = "user";
    public static String CHANGE_ENDPOINT_PROTECTION_ACTION = "action";
    public static String CHANGE_ENDPOINT_PROTECTION_CHANGE_TYPE = "change_type";
    public static String CHANGE_ENDPOINT_PROTECTION_DEST = "dest";
    public static String CHANGE_ENDPOINT_PROTECTION_HASH = "hash";
    public static String CHANGE_ENDPOINT_PROTECTION_GID = "gid";
    public static String CHANGE_ENDPOINT_PROTECTION_ISDR = "isdr";
    public static String CHANGE_ENDPOINT_PROTECTION_MODE = "mode";
    public static String CHANGE_ENDPOINT_PROTECTION_MODTIME = "modtime";
    public static String CHANGE_ENDPOINT_PROTECTION_PATH = "path";
    public static String CHANGE_ENDPOINT_PROTECTION_SIZE = "size";
    public static String CHANGE_ENDPOINT_PROTECTION_UID = "uid";
    public static String CHANGE_NETWORK_PROTECTION_ACTION = "action";
    public static String CHANGE_NETWORK_PROTECTION_COMMAND = "command";
    public static String CHANGE_NETWORK_PROTECTION_DVC = "dvc";
    public static String CHANGE_NETWORK_PROTECTION_USER = "user";
    public static String COMMON_CATEGORY = "category";
    public static String COMMON_COUNT = "count";
    public static String COMMON_DESC = "desc";
    public static String COMMON_DHCP_POOL = "dhcp_pool";
    public static String COMMON_DURATION = "duration";
    public static String COMMON_DVC_HOST = "dvc_host";
    public static String COMMON_DVC_IP = "dvc_ip";
    public static String COMMON_DVC_IP6 = "dvc_ip6";
    public static String COMMON_DVC_LOCATION = "dvc_location";
    public static String COMMON_DVC_MAC = "dvc_mac";
    public static String COMMON_DVC_NT_DOMAIN = "dvc_nt_domain";
    public static String COMMON_DVC_NT_HOST = "dvc_nt_host";
    public static String COMMON_DVC_TIME = "dvc_time";
    public static String COMMON_END_TIME = "end_time";
    public static String COMMON_EVENT_ID = "event_id";
    public static String COMMON_LENGTH = "length";
    public static String COMMON_LOG_LEVEL = "log_level";
    public static String COMMON_NAME = "name";
    public static String COMMON_PID = "pid";
    public static String COMMON_PRIORITY = "priority";
    public static String COMMON_PRODUCT = "product";
    public static String COMMON_PRODUCT_VERSION = "product_version";
    public static String COMMON_REASON = "reason";
    public static String COMMON_RESULT = "result";
    public static String COMMON_SEVERITY = "severity";
    public static String COMMON_START_TIME = "start_time";
    public static String COMMON_TRANSACTION_ID = "transaction_id";
    public static String COMMON_URL = "url";
    public static String COMMON_VENDOR = "vendor";
    public static String DNS_DEST_DOMAIN = "dest_domain";
    public static String DNS_DEST_RECORD = "dest_record";
    public static String DNS_DEST_ZONE = "dest_zone";
    public static String DNS_RECORD_CLASS = "record_class";
    public static String DNS_RECORD_TYPE = "record_type";
    public static String DNS_SRC_DOMAIN = "src_domain";
    public static String DNS_SRC_RECORD = "src_record";
    public static String DNS_SRC_ZONE = "src_zone";
    public static String EMAIL_RECIPIENT = "recipient";
    public static String EMAIL_SENDER = "sender";
    public static String EMAIL_SUBJECT = "subject";
    public static String FILE_ACCESS_TIME = "file_access_time";
    public static String FILE_CREATE_TIME = "file_create_time";
    public static String FILE_HASH = "file_hash";
    public static String FILE_MODIFY_TIME = "file_modify_time";
    public static String FILE_NAME = "file_name";
    public static String FILE_PATH = "file_path";
    public static String FILE_PERMISSION = "file_permission";
    public static String FILE_SIZE = "file_size";
    public static String INTRUSION_DETECTION_CATEGORY = "category";
    public static String INTRUSION_DETECTION_DEST = "dest";
    public static String INTRUSION_DETECTION_DVC = "dvc";
    public static String INTRUSION_DETECTION_IDS_TYPE = "ids_type";
    public static String INTRUSION_DETECTION_PRODUCT = "product";
    public static String INTRUSION_DETECTION_SEVERITY = "severity";
    public static String INTRUSION_DETECTION_SIGNATURE = "signature";
    public static String INTRUSION_DETECTION_SRC = "src";
    public static String INTRUSION_DETECTION_USER = "user";
    public static String INTRUSION_DETECTION_VENDOR = "vendor";
    public static String MALWARE_ENDPOINT_PROTECTION_ACTION = "action";
    public static String MALWARE_ENDPOINT_PROTECTION_DEST_NT_DOMAIN = "dest_nt_domain";
    public static String MALWARE_ENDPOINT_PROTECTION_FILE_HASH = "file_hash";
    public static String MALWARE_ENDPOINT_PROTECTION_FILE_NAME = "file_name";
    public static String MALWARE_ENDPOINT_PROTECTION_FILE_PATH = "file_path";
    public static String MALWARE_ENDPOINT_PROTECTION_PRODUCT = "product";
    public static String MALWARE_ENDPOINT_PROTECTION_PRODUCT_VERSION = "product_version";
    public static String MALWARE_ENDPOINT_PROTECTION_SIGNATURE = "signature";
    public static String MALWARE_ENDPOINT_PROTECTION_SIGNATURE_VERSION = "signature_version";
    public static String MALWARE_ENDPOINT_PROTECTION_DEST = "dest";
    public static String MALWARE_ENDPOINT_PROTECTION_SRC_NT_DOMAIN = "src_nt_domain";
    public static String MALWARE_ENDPOINT_PROTECTION_USER = "user";
    public static String MALWARE_ENDPOINT_PROTECTION_VENDOR = "vendor";
    public static String MALWARE_NETWORK_PROTECTION_PRODUCT = "product";
    public static String MALWARE_NETWORK_PROTECTION_SEVERITY = "severity";
    public static String MALWARE_NETWORK_PROTECTION_VENDOR = "vendor";
    public static String NETWORK_TRAFFIC_ESS_ACTION = "action";
    public static String NETWORK_TRAFFIC_ESS_DEST_PORT = "dest_port";
    public static String NETWORK_TRAFFIC_ESS_PRODUCT = "product";
    public static String NETWORK_TRAFFIC_ESS_SRC_PORT = "src_port";
    public static String NETWORK_TRAFFIC_ESS_VENDOR = "vendor";
    public static String NETWORK_TRAFFIC_GENERIC_APP_LAYER = "app_layer";
    public static String NETWORK_TRAFFIC_GENERIC_BYTES_IN = "bytes_in";
    public static String NETWORK_TRAFFIC_GENERIC_BYTES_OUT = "bytes_out";
    public static String NETWORK_TRAFFIC_GENERIC_CHANNEL = "channel";
    public static String NETWORK_TRAFFIC_GENERIC_CVE = "cve";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_APP = "dest_app";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_CNC_CHANNEL = "dest_cnc_channel";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_CNC_NAME = "dest_cnc_name";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_CNC_PORT = "dest_cnc_port";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_COUNTRY = "dest_country";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_HOST = "dest_host";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_INT = "dest_int";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_IP = "dest_ip";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_IPV6 = "dest_ipv6";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_LAT = "dest_lat";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_LONG = "dest_long";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_MAC = "dest_mac";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_NT_DOMAIN = "dest_nt_domain";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_NT_HOST = "dest_nt_host";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_PORT = "dest_port";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_TRANSLATED_IP = "dest_translated_ip";
    public static String NETWORK_TRAFFIC_GENERIC_DEST_TRANSLATED_PORT = "dest_translated_port";
    public static String NETWORK_TRAFFIC_GENERIC_IP_VERSION = "ip_version";
    public static String NETWORK_TRAFFIC_GENERIC_OUTBOUND_INTERFACE = "outbound_interface";
    public static String NETWORK_TRAFFIC_GENERIC_PACKETS_IN = "packets_in";
    public static String NETWORK_TRAFFIC_GENERIC_PACKETS_OUT = "packets_out";
    public static String NETWORK_TRAFFIC_GENERIC_PROTO = "proto";
    public static String NETWORK_TRAFFIC_GENERIC_SESSION_ID = "session_id";
    public static String NETWORK_TRAFFIC_GENERIC_SSID = "ssid";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_COUNTRY = "src_country";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_HOST = "src_host";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_INT = "src_int";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_IP = "src_ip";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_IPV6 = "src_ipv6";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_LAT = "src_lat";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_LONG = "src_long";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_MAC = "src_mac";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_NT_DOMAIN = "src_nt_domain";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_NT_HOST = "src_nt_host";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_PORT = "src_port";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_TRANSLATED_IP = "src_translated_ip";
    public static String NETWORK_TRAFFIC_GENERIC_SRC_TRANSLATED_PORT = "src_translated_port";
    public static String NETWORK_TRAFFIC_GENERIC_SYSLOG_ID = "syslog_id";
    public static String NETWORK_TRAFFIC_GENERIC_SYSLOG_PRIORITY = "syslog_priority";
    public static String NETWORK_TRAFFIC_GENERIC_TCP_FLAG = "tcp_flag";
    public static String NETWORK_TRAFFIC_GENERIC_TOS = "tos";
    public static String NETWORK_TRAFFIC_GENERIC_TRANSPORT = "transport";
    public static String NETWORK_TRAFFIC_GENERIC_TTL = "ttl";
    public static String NETWORK_TRAFFIC_GENERIC_VLAN_ID = "vlan_id";
    public static String NETWORK_TRAFFIC_GENERIC_VLAN_NAME = "vlan_name";
    public static String PACKET_FILTERING_ACTION = "action";
    public static String PACKET_FILTERING_DEST_PORT = "dest_port";
    public static String PACKET_FILTERING_DIRECTION = "direction";
    public static String PACKET_FILTERING_DVC = "dvc";
    public static String PACKET_FILTERING_RULE = "rule";
    public static String PACKET_FILTERING_SVC_PORT = "svc_port";
    public static String PROXY_ACTION = "action";
    public static String PROXY_DEST = "dest";
    public static String PROXY_HTTP_CONTENT_TYPE = "http_content_type";
    public static String PROXY_HTTP_METHOD = "http_method";
    public static String PROXY_HTTP_REFER = "http_refer";
    public static String PROXY_HTTP_RESPONSE = "http_response";
    public static String PROXY_HTTP_USER_AGENT = "http_user_agent";
    public static String PROXY_PRODUCT = "product";
    public static String PROXY_SRC = "src";
    public static String PROXY_STATUS = "status";
    public static String PROXY_USER = "user";
    public static String PROXY_URL = "url";
    public static String PROXY_VENDOR = "vendor";
    public static String SYSTEM_CENTER_APP = "app";
    public static String SYSTEM_CENTER_FREEMBYTES = "FreeMBytes";
    public static String SYSTEM_CENTER_KERNEL_RELEASE = "kernel_release";
    public static String SYSTEM_CENTER_LABEL = "label";
    public static String SYSTEM_CENTER_MOUNT = "mount";
    public static String SYSTEM_CENTER_OS = "os";
    public static String SYSTEM_CENTER_PERCENTPROCESSORTIME = "PercentProcessorTime";
    public static String SYSTEM_CENTER_SETLOCALDEFS = "setlocaldefs";
    public static String SYSTEM_CENTER_SELINUX = "selinux";
    public static String SYSTEM_CENTER_SELINUXTYPE = "selinuxtype";
    public static String SYSTEM_CENTER_SHELL = "shell";
    public static String SYSTEM_CENTER_SRC_PORT = "src_port";
    public static String SYSTEM_CENTER_SSHD_PROTOCOL = "sshd_protocol";
    public static String SYSTEM_CENTER_STARTMODE = "Startmode";
    public static String SYSTEM_CENTER_SYSTEMUPTIME = "SystemUptime";
    public static String SYSTEM_CENTER_TOTALMBYTES = "TotalMBytes";
    public static String SYSTEM_CENTER_USEDMBYTES = "UsedMBytes";
    public static String SYSTEM_CENTER_USER = "user";
    public static String SYSTEM_CENTER_UPDATES = "updates";
    public static String TRAFFIC_DEST = "dest";
    public static String TRAFFIC_DVC = "dvc";
    public static String TRAFFIC_SRC = "src";
    public static String UPDATE_PACKAGE = "package";
    public static String USER_INFO_UPDATES_AFFECTED_USER = "affected_user";
    public static String USER_INFO_UPDATES_AFFECTED_USER_GROUP = "affected_user_group";
    public static String USER_INFO_UPDATES_AFFECTED_USER_GROUP_ID = "affected_user_group_id";
    public static String USER_INFO_UPDATES_AFFECTED_USER_ID = "affected_user_id";
    public static String USER_INFO_UPDATES_AFFECTED_USER_PRIVILEGE = "affected_user_privilege";
    public static String USER_INFO_UPDATES_USER = "user";
    public static String USER_INFO_UPDATES_USER_GROUP = "user_group";
    public static String USER_INFO_UPDATES_USER_GROUP_ID = "user_group_id";
    public static String USER_INFO_UPDATES_USER_ID = "user_id";
    public static String USER_INFO_UPDATES_USER_PRIVILEGE = "user_privilege";
    public static String USER_INFO_UPDATES_USER_SUBJECT = "user_subject";
    public static String USER_INFO_UPDATES_USER_SUBJECT_ID = "user_subject_id";
    public static String USER_INFO_UPDATES_USER_SUBJECT_PRIVILEGE = "user_subject_privilege";
    public static String VULNERABILITY_CATEGORY = "category";
    public static String VULNERABILITY_DEST = "dest";
    public static String VULNERABILITY_OS = "os";
    public static String VULNERABILITY_SEVERITY = "severity";
    public static String VULNERABILITY_SIGNATURE = "signature";
    public static String WINDOWS_ADMIN_OBJECT_NAME = "object_name";
    public static String WINDOWS_ADMIN_OBJECT_TYPE = "object_type";
    public static String WINDOWS_ADMIN_OBJECT_HANDLE = "object_handle";

    public SplunkLogEvent(String string, String string2, boolean bl, boolean bl2) {
        this.quoteValues = bl2;
        this.useInternalDate = bl;
        this.addPair(PREFIX_NAME, string);
        this.addPair(PREFIX_EVENT_ID, string2);
    }

    public SplunkLogEvent(String string, String string2) {
        this(string, string2, true, true);
    }

    public SplunkLogEvent() {
    }

    public SplunkLogEvent clone() {
        SplunkLogEvent splunkLogEvent = new SplunkLogEvent();
        splunkLogEvent.quoteValues = this.quoteValues;
        splunkLogEvent.useInternalDate = this.useInternalDate;
        splunkLogEvent.eventMessage.append(this.eventMessage);
        return splunkLogEvent;
    }

    public void addPair(String string, char c) {
        this.addPair(string, String.valueOf(c));
    }

    public void addPair(String string, boolean bl) {
        this.addPair(string, String.valueOf(bl));
    }

    public void addPair(String string, double d) {
        this.addPair(string, String.valueOf(d));
    }

    public void addPair(String string, long l) {
        this.addPair(string, String.valueOf(l));
    }

    public void addPair(String string, int n) {
        this.addPair(string, String.valueOf(n));
    }

    public void addPair(String string, Object object) {
        this.addPair(string, object.toString());
    }

    public void addThrowable(Throwable throwable) {
        this.addThrowableObject(throwable, -1);
    }

    public void addThrowable(Throwable throwable, int n) {
        this.addThrowableObject(throwable, n);
    }

    private void addThrowableObject(Throwable throwable, int n) {
        this.addPair(THROWABLE_CLASS, throwable.getClass().getCanonicalName());
        this.addPair(THROWABLE_MESSAGE, throwable.getMessage());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (n != -1 && n < ++n2) break;
            stringBuffer.append(stackTraceElement.toString()).append(",");
        }
        this.addPair(THROWABLE_STACKTRACE_ELEMENTS, stringBuffer.toString());
    }

    public void addPair(String string, String string2) {
        if (this.quoteValues) {
            this.eventMessage.append(string).append(KVDELIM).append('\"').append(string2).append('\"').append(PAIRDELIM);
        } else {
            this.eventMessage.append(string).append(KVDELIM).append(string2).append(PAIRDELIM);
        }
    }

    public String toString() {
        String string = "";
        if (this.useInternalDate) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DATEFORMATTER.format(new Date())).append(PAIRDELIM).append(this.eventMessage);
            string = stringBuffer.toString();
        } else {
            string = this.eventMessage.toString();
        }
        return string.substring(0, string.length() - PAIRDELIM.length());
    }

    public void setAcManagementDestNtDomain(String string) {
        this.addPair(AC_MANAGEMENT_DEST_NT_DOMAIN, string);
    }

    public void setAcManagementSignature(String string) {
        this.addPair(AC_MANAGEMENT_SIGNATURE, string);
    }

    public void setAcManagementSrcNtDomain(String string) {
        this.addPair(AC_MANAGEMENT_SRC_NT_DOMAIN, string);
    }

    public void setAuthAction(String string) {
        this.addPair(AUTH_ACTION, string);
    }

    public void setAuthApp(String string) {
        this.addPair(AUTH_APP, string);
    }

    public void setAuthDest(String string) {
        this.addPair(AUTH_DEST, string);
    }

    public void setAuthSrc(String string) {
        this.addPair(AUTH_SRC, string);
    }

    public void setAuthSrcUser(String string) {
        this.addPair(AUTH_SRC_USER, string);
    }

    public void setAuthUser(String string) {
        this.addPair(AUTH_USER, string);
    }

    public void setChangeEndpointProtectionAction(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_ACTION, string);
    }

    public void setChangeEndpointProtectionChangeType(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_CHANGE_TYPE, string);
    }

    public void setChangeEndpointProtectionDest(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_DEST, string);
    }

    public void setChangeEndpointProtectionHash(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_HASH, string);
    }

    public void setChangeEndpointProtectionGid(long l) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_GID, l);
    }

    public void setChangeEndpointProtectionIsdr(boolean bl) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_ISDR, bl);
    }

    public void setChangeEndpointProtectionMode(long l) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_MODE, l);
    }

    public void setChangeEndpointProtectionModtime(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_MODTIME, string);
    }

    public void setChangeEndpointProtectionPath(String string) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_PATH, string);
    }

    public void setChangeEndpointProtectionSize(long l) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_SIZE, l);
    }

    public void setChangeEndpointProtectionUid(long l) {
        this.addPair(CHANGE_ENDPOINT_PROTECTION_UID, l);
    }

    public void setChangeNetworkProtectionAction(String string) {
        this.addPair(CHANGE_NETWORK_PROTECTION_ACTION, string);
    }

    public void setChangeNetworkProtectionCommand(String string) {
        this.addPair(CHANGE_NETWORK_PROTECTION_COMMAND, string);
    }

    public void setChangeNetworkProtectionDvc(String string) {
        this.addPair(CHANGE_NETWORK_PROTECTION_DVC, string);
    }

    public void setChangeNetworkProtectionUser(String string) {
        this.addPair(CHANGE_NETWORK_PROTECTION_USER, string);
    }

    public void setCommonCategory(String string) {
        this.addPair(COMMON_CATEGORY, string);
    }

    public void setCommonCount(String string) {
        this.addPair(COMMON_COUNT, string);
    }

    public void setCommonDesc(String string) {
        this.addPair(COMMON_DESC, string);
    }

    public void setCommonDhcpPool(String string) {
        this.addPair(COMMON_DHCP_POOL, string);
    }

    public void setCommonDuration(long l) {
        this.addPair(COMMON_DURATION, l);
    }

    public void setCommonDvcHost(String string) {
        this.addPair(COMMON_DVC_HOST, string);
    }

    public void setCommonDvcIp(String string) {
        this.addPair(COMMON_DVC_IP, string);
    }

    public void setCommonDvcIp6(String string) {
        this.addPair(COMMON_DVC_IP6, string);
    }

    public void setCommonDvcLocation(String string) {
        this.addPair(COMMON_DVC_LOCATION, string);
    }

    public void setCommonDvcMac(String string) {
        this.addPair(COMMON_DVC_MAC, string);
    }

    public void setCommonDvcNtDomain(String string) {
        this.addPair(COMMON_DVC_NT_DOMAIN, string);
    }

    public void setCommonDvcNtHost(String string) {
        this.addPair(COMMON_DVC_NT_HOST, string);
    }

    public void setCommonDvcTime(long l) {
        this.addPair(COMMON_DVC_TIME, l);
    }

    public void setCommonEndTime(long l) {
        this.addPair(COMMON_END_TIME, l);
    }

    public void setCommonEventId(long l) {
        this.addPair(COMMON_EVENT_ID, l);
    }

    public void setCommonLength(long l) {
        this.addPair(COMMON_LENGTH, l);
    }

    public void setCommonLogLevel(String string) {
        this.addPair(COMMON_LOG_LEVEL, string);
    }

    public void setCommonName(String string) {
        this.addPair(COMMON_NAME, string);
    }

    public void setCommonPid(long l) {
        this.addPair(COMMON_PID, l);
    }

    public void setCommonPriority(long l) {
        this.addPair(COMMON_PRIORITY, l);
    }

    public void setCommonProduct(String string) {
        this.addPair(COMMON_PRODUCT, string);
    }

    public void setCommonProductVersion(long l) {
        this.addPair(COMMON_PRODUCT_VERSION, l);
    }

    public void setCommonReason(String string) {
        this.addPair(COMMON_REASON, string);
    }

    public void setCommonResult(String string) {
        this.addPair(COMMON_RESULT, string);
    }

    public void setCommonSeverity(String string) {
        this.addPair(COMMON_SEVERITY, string);
    }

    public void setCommonStartTime(long l) {
        this.addPair(COMMON_START_TIME, l);
    }

    public void setCommonTransactionId(String string) {
        this.addPair(COMMON_TRANSACTION_ID, string);
    }

    public void setCommonUrl(String string) {
        this.addPair(COMMON_URL, string);
    }

    public void setCommonVendor(String string) {
        this.addPair(COMMON_VENDOR, string);
    }

    public void setDnsDestDomain(String string) {
        this.addPair(DNS_DEST_DOMAIN, string);
    }

    public void setDnsDestRecord(String string) {
        this.addPair(DNS_DEST_RECORD, string);
    }

    public void setDnsDestZone(String string) {
        this.addPair(DNS_DEST_ZONE, string);
    }

    public void setDnsRecordClass(String string) {
        this.addPair(DNS_RECORD_CLASS, string);
    }

    public void setDnsRecordType(String string) {
        this.addPair(DNS_RECORD_TYPE, string);
    }

    public void setDnsSrcDomain(String string) {
        this.addPair(DNS_SRC_DOMAIN, string);
    }

    public void setDnsSrcRecord(String string) {
        this.addPair(DNS_SRC_RECORD, string);
    }

    public void setDnsSrcZone(String string) {
        this.addPair(DNS_SRC_ZONE, string);
    }

    public void setEmailRecipient(String string) {
        this.addPair(EMAIL_RECIPIENT, string);
    }

    public void setEmailSender(String string) {
        this.addPair(EMAIL_SENDER, string);
    }

    public void setEmailSubject(String string) {
        this.addPair(EMAIL_SUBJECT, string);
    }

    public void setFileAccessTime(long l) {
        this.addPair(FILE_ACCESS_TIME, l);
    }

    public void setFileCreateTime(long l) {
        this.addPair(FILE_CREATE_TIME, l);
    }

    public void setFileHash(String string) {
        this.addPair(FILE_HASH, string);
    }

    public void setFileModifyTime(long l) {
        this.addPair(FILE_MODIFY_TIME, l);
    }

    public void setFileName(String string) {
        this.addPair(FILE_NAME, string);
    }

    public void setFilePath(String string) {
        this.addPair(FILE_PATH, string);
    }

    public void setFilePermission(String string) {
        this.addPair(FILE_PERMISSION, string);
    }

    public void setFileSize(long l) {
        this.addPair(FILE_SIZE, l);
    }

    public void setIntrusionDetectionCategory(String string) {
        this.addPair(INTRUSION_DETECTION_CATEGORY, string);
    }

    public void setIntrusionDetectionDest(String string) {
        this.addPair(INTRUSION_DETECTION_DEST, string);
    }

    public void setIntrusionDetectionDvc(String string) {
        this.addPair(INTRUSION_DETECTION_DVC, string);
    }

    public void setIntrusionDetectionIdsType(String string) {
        this.addPair(INTRUSION_DETECTION_IDS_TYPE, string);
    }

    public void setIntrusionDetectionProduct(String string) {
        this.addPair(INTRUSION_DETECTION_PRODUCT, string);
    }

    public void setIntrusionDetectionSeverity(String string) {
        this.addPair(INTRUSION_DETECTION_SEVERITY, string);
    }

    public void setIntrusionDetectionSignature(String string) {
        this.addPair(INTRUSION_DETECTION_SIGNATURE, string);
    }

    public void setIntrusionDetectionSrc(String string) {
        this.addPair(INTRUSION_DETECTION_SRC, string);
    }

    public void setIntrusionDetectionUser(String string) {
        this.addPair(INTRUSION_DETECTION_USER, string);
    }

    public void setIntrusionDetectionVendor(String string) {
        this.addPair(INTRUSION_DETECTION_VENDOR, string);
    }

    public void setMalwareEndpointProtectionAction(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_ACTION, string);
    }

    public void setMalwareEndpointProtectionDestNtDomain(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_DEST_NT_DOMAIN, string);
    }

    public void setMalwareEndpointProtectionFileHash(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_FILE_HASH, string);
    }

    public void setMalwareEndpointProtectionFileName(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_FILE_NAME, string);
    }

    public void setMalwareEndpointProtectionFilePath(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_FILE_PATH, string);
    }

    public void setMalwareEndpointProtectionProduct(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_PRODUCT, string);
    }

    public void setMalwareEndpointProtectionProductVersion(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_PRODUCT_VERSION, string);
    }

    public void setMalwareEndpointProtectionSignature(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_SIGNATURE, string);
    }

    public void setMalwareEndpointProtectionSignatureVersion(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_SIGNATURE_VERSION, string);
    }

    public void setMalwareEndpointProtectionDest(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_DEST, string);
    }

    public void setMalwareEndpointProtectionSrcNtDomain(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_SRC_NT_DOMAIN, string);
    }

    public void setMalwareEndpointProtectionUser(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_USER, string);
    }

    public void setMalwareEndpointProtectionVendor(String string) {
        this.addPair(MALWARE_ENDPOINT_PROTECTION_VENDOR, string);
    }

    public void setMalwareNetworkProtectionProduct(String string) {
        this.addPair(MALWARE_NETWORK_PROTECTION_PRODUCT, string);
    }

    public void setMalwareNetworkProtectionSeverity(String string) {
        this.addPair(MALWARE_NETWORK_PROTECTION_SEVERITY, string);
    }

    public void setMalwareNetworkProtectionVendor(String string) {
        this.addPair(MALWARE_NETWORK_PROTECTION_VENDOR, string);
    }

    public void setNetworkTrafficEssAction(String string) {
        this.addPair(NETWORK_TRAFFIC_ESS_ACTION, string);
    }

    public void setNetworkTrafficEssDestPort(int n) {
        this.addPair(NETWORK_TRAFFIC_ESS_DEST_PORT, n);
    }

    public void setNetworkTrafficEssProduct(String string) {
        this.addPair(NETWORK_TRAFFIC_ESS_PRODUCT, string);
    }

    public void setNetworkTrafficEssSrcPort(int n) {
        this.addPair(NETWORK_TRAFFIC_ESS_SRC_PORT, n);
    }

    public void setNetworkTrafficEssVendor(String string) {
        this.addPair(NETWORK_TRAFFIC_ESS_VENDOR, string);
    }

    public void setNetworkTrafficGenericAppLayer(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_APP_LAYER, string);
    }

    public void setNetworkTrafficGenericBytesIn(long l) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_BYTES_IN, l);
    }

    public void setNetworkTrafficGenericBytesOut(long l) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_BYTES_OUT, l);
    }

    public void setNetworkTrafficGenericChannel(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_CHANNEL, string);
    }

    public void setNetworkTrafficGenericCve(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_CVE, string);
    }

    public void setNetworkTrafficGenericDestApp(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_APP, string);
    }

    public void setNetworkTrafficGenericDestCncChannel(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_CNC_CHANNEL, string);
    }

    public void setNetworkTrafficGenericDestCncName(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_CNC_NAME, string);
    }

    public void setNetworkTrafficGenericDestCncPort(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_CNC_PORT, string);
    }

    public void setNetworkTrafficGenericDestCountry(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_COUNTRY, string);
    }

    public void setNetworkTrafficGenericDestHost(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_HOST, string);
    }

    public void setNetworkTrafficGenericDestInt(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_INT, string);
    }

    public void setNetworkTrafficGenericDestIp(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_IP, string);
    }

    public void setNetworkTrafficGenericDestIpv6(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_IPV6, string);
    }

    public void setNetworkTrafficGenericDestLat(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_LAT, n);
    }

    public void setNetworkTrafficGenericDestLong(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_LONG, n);
    }

    public void setNetworkTrafficGenericDestMac(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_MAC, string);
    }

    public void setNetworkTrafficGenericDestNtDomain(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_NT_DOMAIN, string);
    }

    public void setNetworkTrafficGenericDestNtHost(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_NT_HOST, string);
    }

    public void setNetworkTrafficGenericDestPort(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_PORT, n);
    }

    public void setNetworkTrafficGenericDestTranslatedIp(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_TRANSLATED_IP, string);
    }

    public void setNetworkTrafficGenericDestTranslatedPort(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_DEST_TRANSLATED_PORT, n);
    }

    public void setNetworkTrafficGenericIpVersion(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_IP_VERSION, n);
    }

    public void setNetworkTrafficGenericOutboundInterface(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_OUTBOUND_INTERFACE, string);
    }

    public void setNetworkTrafficGenericPacketsIn(long l) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_PACKETS_IN, l);
    }

    public void setNetworkTrafficGenericPacketsOut(long l) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_PACKETS_OUT, l);
    }

    public void setNetworkTrafficGenericProto(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_PROTO, string);
    }

    public void setNetworkTrafficGenericSessionId(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SESSION_ID, string);
    }

    public void setNetworkTrafficGenericSsid(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SSID, string);
    }

    public void setNetworkTrafficGenericSrcCountry(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_COUNTRY, string);
    }

    public void setNetworkTrafficGenericSrcHost(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_HOST, string);
    }

    public void setNetworkTrafficGenericSrcInt(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_INT, string);
    }

    public void setNetworkTrafficGenericSrcIp(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_IP, string);
    }

    public void setNetworkTrafficGenericSrcIpv6(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_IPV6, string);
    }

    public void setNetworkTrafficGenericSrcLat(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_LAT, n);
    }

    public void setNetworkTrafficGenericSrcLong(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_LONG, n);
    }

    public void setNetworkTrafficGenericSrcMac(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_MAC, string);
    }

    public void setNetworkTrafficGenericSrcNtDomain(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_NT_DOMAIN, string);
    }

    public void setNetworkTrafficGenericSrcNtHost(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_NT_HOST, string);
    }

    public void setNetworkTrafficGenericSrcPort(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_PORT, n);
    }

    public void setNetworkTrafficGenericSrcTranslatedIp(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_TRANSLATED_IP, string);
    }

    public void setNetworkTrafficGenericSrcTranslatedPort(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SRC_TRANSLATED_PORT, n);
    }

    public void setNetworkTrafficGenericSyslogId(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SYSLOG_ID, string);
    }

    public void setNetworkTrafficGenericSyslogPriority(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_SYSLOG_PRIORITY, string);
    }

    public void setNetworkTrafficGenericTcpFlag(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_TCP_FLAG, string);
    }

    public void setNetworkTrafficGenericTos(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_TOS, string);
    }

    public void setNetworkTrafficGenericTransport(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_TRANSPORT, string);
    }

    public void setNetworkTrafficGenericTtl(int n) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_TTL, n);
    }

    public void setNetworkTrafficGenericVlanId(long l) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_VLAN_ID, l);
    }

    public void setNetworkTrafficGenericVlanName(String string) {
        this.addPair(NETWORK_TRAFFIC_GENERIC_VLAN_NAME, string);
    }

    public void setPacketFilteringAction(String string) {
        this.addPair(PACKET_FILTERING_ACTION, string);
    }

    public void setPacketFilteringDestPort(int n) {
        this.addPair(PACKET_FILTERING_DEST_PORT, n);
    }

    public void setPacketFilteringDirection(String string) {
        this.addPair(PACKET_FILTERING_DIRECTION, string);
    }

    public void setPacketFilteringDvc(String string) {
        this.addPair(PACKET_FILTERING_DVC, string);
    }

    public void setPacketFilteringRule(String string) {
        this.addPair(PACKET_FILTERING_RULE, string);
    }

    public void setPacketFilteringSvcPort(int n) {
        this.addPair(PACKET_FILTERING_SVC_PORT, n);
    }

    public void setProxyAction(String string) {
        this.addPair(PROXY_ACTION, string);
    }

    public void setProxyDest(String string) {
        this.addPair(PROXY_DEST, string);
    }

    public void setProxyHttpContentType(String string) {
        this.addPair(PROXY_HTTP_CONTENT_TYPE, string);
    }

    public void setProxyHttpMethod(String string) {
        this.addPair(PROXY_HTTP_METHOD, string);
    }

    public void setProxyHttpRefer(String string) {
        this.addPair(PROXY_HTTP_REFER, string);
    }

    public void setProxyHttpResponse(int n) {
        this.addPair(PROXY_HTTP_RESPONSE, n);
    }

    public void setProxyHttpUserAgent(String string) {
        this.addPair(PROXY_HTTP_USER_AGENT, string);
    }

    public void setProxyProduct(String string) {
        this.addPair(PROXY_PRODUCT, string);
    }

    public void setProxySrc(String string) {
        this.addPair(PROXY_SRC, string);
    }

    public void setProxyStatus(int n) {
        this.addPair(PROXY_STATUS, n);
    }

    public void setProxyUser(String string) {
        this.addPair(PROXY_USER, string);
    }

    public void setProxyUrl(String string) {
        this.addPair(PROXY_URL, string);
    }

    public void setProxyVendor(String string) {
        this.addPair(PROXY_VENDOR, string);
    }

    public void setSystemCenterApp(String string) {
        this.addPair(SYSTEM_CENTER_APP, string);
    }

    public void setSystemCenterFreembytes(long l) {
        this.addPair(SYSTEM_CENTER_FREEMBYTES, l);
    }

    public void setSystemCenterKernelRelease(String string) {
        this.addPair(SYSTEM_CENTER_KERNEL_RELEASE, string);
    }

    public void setSystemCenterLabel(String string) {
        this.addPair(SYSTEM_CENTER_LABEL, string);
    }

    public void setSystemCenterMount(String string) {
        this.addPair(SYSTEM_CENTER_MOUNT, string);
    }

    public void setSystemCenterOs(String string) {
        this.addPair(SYSTEM_CENTER_OS, string);
    }

    public void setSystemCenterPercentprocessortime(int n) {
        this.addPair(SYSTEM_CENTER_PERCENTPROCESSORTIME, n);
    }

    public void setSystemCenterSetlocaldefs(int n) {
        this.addPair(SYSTEM_CENTER_SETLOCALDEFS, n);
    }

    public void setSystemCenterSelinux(String string) {
        this.addPair(SYSTEM_CENTER_SELINUX, string);
    }

    public void setSystemCenterSelinuxtype(String string) {
        this.addPair(SYSTEM_CENTER_SELINUXTYPE, string);
    }

    public void setSystemCenterShell(String string) {
        this.addPair(SYSTEM_CENTER_SHELL, string);
    }

    public void setSystemCenterSrcPort(int n) {
        this.addPair(SYSTEM_CENTER_SRC_PORT, n);
    }

    public void setSystemCenterSshdProtocol(String string) {
        this.addPair(SYSTEM_CENTER_SSHD_PROTOCOL, string);
    }

    public void setSystemCenterStartmode(String string) {
        this.addPair(SYSTEM_CENTER_STARTMODE, string);
    }

    public void setSystemCenterSystemuptime(long l) {
        this.addPair(SYSTEM_CENTER_SYSTEMUPTIME, l);
    }

    public void setSystemCenterTotalmbytes(long l) {
        this.addPair(SYSTEM_CENTER_TOTALMBYTES, l);
    }

    public void setSystemCenterUsedmbytes(long l) {
        this.addPair(SYSTEM_CENTER_USEDMBYTES, l);
    }

    public void setSystemCenterUser(String string) {
        this.addPair(SYSTEM_CENTER_USER, string);
    }

    public void setSystemCenterUpdates(long l) {
        this.addPair(SYSTEM_CENTER_UPDATES, l);
    }

    public void setTrafficDest(String string) {
        this.addPair(TRAFFIC_DEST, string);
    }

    public void setTrafficDvc(String string) {
        this.addPair(TRAFFIC_DVC, string);
    }

    public void setTrafficSrc(String string) {
        this.addPair(TRAFFIC_SRC, string);
    }

    public void setUpdatePackage(String string) {
        this.addPair(UPDATE_PACKAGE, string);
    }

    public void setUserInfoUpdatesAffectedUser(String string) {
        this.addPair(USER_INFO_UPDATES_AFFECTED_USER, string);
    }

    public void setUserInfoUpdatesAffectedUserGroup(String string) {
        this.addPair(USER_INFO_UPDATES_AFFECTED_USER_GROUP, string);
    }

    public void setUserInfoUpdatesAffectedUserGroupId(int n) {
        this.addPair(USER_INFO_UPDATES_AFFECTED_USER_GROUP_ID, n);
    }

    public void setUserInfoUpdatesAffectedUserId(int n) {
        this.addPair(USER_INFO_UPDATES_AFFECTED_USER_ID, n);
    }

    public void setUserInfoUpdatesAffectedUserPrivilege(String string) {
        this.addPair(USER_INFO_UPDATES_AFFECTED_USER_PRIVILEGE, string);
    }

    public void setUserInfoUpdatesUser(String string) {
        this.addPair(USER_INFO_UPDATES_USER, string);
    }

    public void setUserInfoUpdatesUserGroup(String string) {
        this.addPair(USER_INFO_UPDATES_USER_GROUP, string);
    }

    public void setUserInfoUpdatesUserGroupId(int n) {
        this.addPair(USER_INFO_UPDATES_USER_GROUP_ID, n);
    }

    public void setUserInfoUpdatesUserId(int n) {
        this.addPair(USER_INFO_UPDATES_USER_ID, n);
    }

    public void setUserInfoUpdatesUserPrivilege(String string) {
        this.addPair(USER_INFO_UPDATES_USER_PRIVILEGE, string);
    }

    public void setUserInfoUpdatesUserSubject(String string) {
        this.addPair(USER_INFO_UPDATES_USER_SUBJECT, string);
    }

    public void setUserInfoUpdatesUserSubjectId(int n) {
        this.addPair(USER_INFO_UPDATES_USER_SUBJECT_ID, n);
    }

    public void setUserInfoUpdatesUserSubjectPrivilege(String string) {
        this.addPair(USER_INFO_UPDATES_USER_SUBJECT_PRIVILEGE, string);
    }

    public void setVulnerabilityCategory(String string) {
        this.addPair(VULNERABILITY_CATEGORY, string);
    }

    public void setVulnerabilityDest(String string) {
        this.addPair(VULNERABILITY_DEST, string);
    }

    public void setVulnerabilityOs(String string) {
        this.addPair(VULNERABILITY_OS, string);
    }

    public void setVulnerabilitySeverity(String string) {
        this.addPair(VULNERABILITY_SEVERITY, string);
    }

    public void setVulnerabilitySignature(String string) {
        this.addPair(VULNERABILITY_SIGNATURE, string);
    }

    public void setWindowsAdminObjectName(String string) {
        this.addPair(WINDOWS_ADMIN_OBJECT_NAME, string);
    }

    public void setWindowsAdminObjectType(String string) {
        this.addPair(WINDOWS_ADMIN_OBJECT_TYPE, string);
    }

    public void setWindowsAdminObjectHandle(String string) {
        this.addPair(WINDOWS_ADMIN_OBJECT_HANDLE, string);
    }
}

