/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.log4j.appender;

import com.splunk.logging.RestEventData;
import com.splunk.logging.SplunkRestInput;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class SplunkRestAppender
extends AppenderSkeleton {
    public static final String STREAM = "stream";
    public static final String SIMPLE = "simple";
    private String user = "";
    private String pass = "";
    private String host = "";
    private int port = 8089;
    private String delivery = "stream";
    private String metaSource = "";
    private String metaSourcetype = "";
    private String metaIndex = "";
    private String metaHostRegex = "";
    private String metaHost = "";
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkRestInput sri;
    private RestEventData red = new RestEventData();
    private String activationKey;

    public SplunkRestAppender() {
    }

    public SplunkRestAppender(Layout layout) {
        this.layout = layout;
    }

    protected void append(LoggingEvent loggingEvent) {
        try {
            if (this.sri == null) {
                this.sri = new SplunkRestInput(this.user, this.pass, this.host, this.port, this.red, this.delivery.equals(STREAM), this.activationKey);
                this.sri.setMaxQueueSize(this.maxQueueSize);
                this.sri.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
            }
        }
        catch (Exception exception) {
            this.errorHandler.error("Couldn't establish REST service for SplunkRestAppender named \"" + this.name + "\".");
            return;
        }
        String string = this.layout.format(loggingEvent);
        if (this.delivery.equals(STREAM)) {
            this.sri.streamEvent(string);
        } else if (this.delivery.equals(SIMPLE)) {
            this.sri.sendEvent(string);
        } else {
            this.errorHandler.error("Unsupported delivery setting for SplunkRestAppender named \"" + this.name + "\".");
            return;
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.sri != null) {
            try {
                this.sri.closeStream();
                this.sri = null;
            }
            catch (Exception exception) {
                Thread.currentThread().interrupt();
                this.sri = null;
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getDelivery() {
        return this.delivery;
    }

    public void setDelivery(String string) {
        this.delivery = string;
    }

    public String getMetaSource() {
        return this.metaSource;
    }

    public void setMetaSource(String string) {
        this.metaSource = string;
        this.red.setSource(string);
    }

    public String getMetaSourcetype() {
        return this.metaSourcetype;
    }

    public void setMetaSourcetype(String string) {
        this.metaSourcetype = string;
        this.red.setSourcetype(string);
    }

    public String getMetaIndex() {
        return this.metaIndex;
    }

    public void setMetaIndex(String string) {
        this.metaIndex = string;
        this.red.setIndex(string);
    }

    public String getMetaHostRegex() {
        return this.metaHostRegex;
    }

    public void setMetaHostRegex(String string) {
        this.metaHostRegex = string;
        this.red.setHostRegex(string);
    }

    public String getMetaHost() {
        return this.metaHost;
    }

    public void setMetaHost(String string) {
        this.metaHost = string;
        this.red.setHost(string);
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String string) {
        this.maxQueueSize = string;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }
}

