/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Input;
import com.splunk.InputKind;
import com.splunk.Service;

public class MonitorInput
extends Input {
    MonitorInput(Service service, String path) {
        super(service, path);
    }

    public String getBlacklist() {
        return this.getString("blacklist", null);
    }

    public String getCrcSalt() {
        return this.getString("crcSalt", null);
    }

    public int getFileCount() {
        return this.getInteger("filecount", -1);
    }

    public boolean getFollowTail() {
        return this.getBoolean("followTail", false);
    }

    public String getHost() {
        return this.getString("host", null);
    }

    public String getHostRegex() {
        return this.getString("host_regex", null);
    }

    public String getIgnoreOlderThan() {
        return this.getString("ignoreOlderThan", null);
    }

    public String getIndex() {
        return this.getString("index");
    }

    @Override
    public InputKind getKind() {
        return InputKind.Monitor;
    }

    public String getQueue() {
        return this.getString("queue", null);
    }

    public boolean getRecursive() {
        return this.getBoolean("recursive", false);
    }

    public int getRcvBuf() {
        return this.getInteger("_rcvbuf");
    }

    public String getSource() {
        return this.getString("source", null);
    }

    public String getSourceType() {
        return this.getString("sourcetype", null);
    }

    public int getTimeBeforeClose() {
        return this.getInteger("time_before_close", -1);
    }

    public String getWhitelist() {
        return this.getString("whitelist", null);
    }

    public void setBlacklist(String blacklist) {
        this.setCacheValue("blacklist", blacklist);
    }

    public void setCheckIndex(boolean index) {
        this.setCacheValue("check-index", index);
    }

    public void setCheckPath(boolean path) {
        this.setCacheValue("check-path", path);
    }

    public void setCrcSalt(String salt) {
        this.setCacheValue("crc-salt", salt);
    }

    public void setFollowTail(boolean followTail) {
        this.setCacheValue("followTail", followTail);
    }

    public void setHost(String host) {
        this.setCacheValue("host", host);
    }

    public void setHostRegex(String regex) {
        this.setCacheValue("host_regex", regex);
    }

    public void setHostSegment(String segment) {
        this.setCacheValue("host_segment", segment);
    }

    public void setIgnoreOlderThan(String time) {
        this.setCacheValue("ignore-older-than", time);
    }

    public void setIndex(String index) {
        this.setCacheValue("index", index);
    }

    public void setRecursive(boolean recursive) {
        this.setCacheValue("recursive", recursive);
    }

    public void setRenameSource(String name) {
        this.setCacheValue("rename-source", name);
    }

    public void setSourcetype(String sourcetype) {
        this.setCacheValue("sourcetype", sourcetype);
    }

    public void setTimeBeforeClose(int period) {
        this.setCacheValue("time-before-close", period);
    }

    public void setWhitelist(String whitelist) {
        this.setCacheValue("whitelist", whitelist);
    }
}

