/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.HECTransportConfig;
import com.splunk.logging.SplunkInput;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class SplunkHECInput
extends SplunkInput {
    private HECTransportConfig config;
    private List<String> batchBuffer;
    private long currentBatchSizeBytes = 0L;
    private long lastEventReceivedTime;
    private CloseableHttpAsyncClient httpClient;
    private URI uri;
    private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };

    public SplunkHECInput(HECTransportConfig hECTransportConfig, String string) throws Exception {
        this.activationKeyCheck(string);
        if (this.activated) {
            this.config = hECTransportConfig;
            this.batchBuffer = Collections.synchronizedList(new LinkedList());
            this.lastEventReceivedTime = System.currentTimeMillis();
            Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(this.getSSLContext(), HOSTNAME_VERIFIER)).build();
            DefaultConnectingIOReactor defaultConnectingIOReactor = new DefaultConnectingIOReactor();
            PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)defaultConnectingIOReactor, registry);
            poolingNHttpClientConnectionManager.setMaxTotal(hECTransportConfig.getPoolsize());
            HttpHost httpHost = new HttpHost(hECTransportConfig.getHost(), hECTransportConfig.getPort());
            poolingNHttpClientConnectionManager.setMaxPerRoute(new HttpRoute(httpHost), hECTransportConfig.getPoolsize());
            this.httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)poolingNHttpClientConnectionManager).build();
            this.uri = new URIBuilder().setScheme(hECTransportConfig.isHttps() ? "https" : "http").setHost(hECTransportConfig.getHost()).setPort(hECTransportConfig.getPort()).setPath("/services/collector").build();
            this.openStream();
            if (hECTransportConfig.isBatchMode()) {
                new BatchBufferActivityCheckerThread().start();
            }
        }
    }

    private SSLContext getSSLContext() {
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                return true;
            }
        };
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContexts.custom().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sSLContext;
    }

    private void openStream() throws Exception {
        this.httpClient.start();
    }

    public void closeStream() {
        try {
            this.httpClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String wrapMessageInQuotes(String string) {
        return "\"" + string + "\"";
    }

    private String escapeMessageIfNeeded(String string) {
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return string2;
        }
        if (string2.startsWith("\"") && string2.endsWith("\"") && !string.substring(1, string.length() - 1).contains("\"")) {
            return string2;
        }
        return "\"" + string.replace("\"", "\\\"") + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamEvent(String string) {
        if (this.activated) {
            String string2 = "";
            try {
                Object object;
                string = this.escapeMessageIfNeeded(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{\"").append("event\":").append(string).append(",\"").append("index\":\"").append(this.config.getIndex()).append("\",\"").append("source\":\"").append(this.config.getSource()).append("\",\"").append("sourcetype\":\"").append(this.config.getSourcetype()).append("\"").append("}");
                string2 = stringBuffer.toString();
                if (this.config.isBatchMode()) {
                    this.lastEventReceivedTime = System.currentTimeMillis();
                    this.currentBatchSizeBytes += (long)string2.length();
                    this.batchBuffer.add(string2);
                    if (this.flushBuffer()) {
                        object = this.batchBuffer;
                        synchronized (object) {
                            string2 = this.rollOutBatchBuffer();
                            this.batchBuffer.clear();
                            this.currentBatchSizeBytes = 0L;
                        }
                        this.hecPost(string2);
                    }
                } else {
                    this.hecPost(string2);
                }
                while (this.queueContainsEvents()) {
                    object = this.dequeue();
                    string2 = object;
                    this.hecPost(string2);
                }
            }
            catch (Exception exception) {
                this.enqueue(string2);
                try {
                    this.closeStream();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    this.openStream();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
    }

    private boolean flushBuffer() {
        return this.currentBatchSizeBytes >= this.config.getMaxBatchSizeBytes() || (long)this.batchBuffer.size() >= this.config.getMaxBatchSizeEvents();
    }

    private String rollOutBatchBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.batchBuffer) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void hecPost(String string) throws Exception {
        HttpPost httpPost = new HttpPost(this.uri);
        httpPost.addHeader("Authorization", "Splunk " + this.config.getToken());
        StringEntity stringEntity = new StringEntity(string, ContentType.create((String)"application/json", (String)"UTF-8"));
        httpPost.setEntity((HttpEntity)stringEntity);
        Future future = this.httpClient.execute((HttpUriRequest)httpPost, null);
        HttpResponse httpResponse = (HttpResponse)future.get();
    }

    class BatchBufferActivityCheckerThread
    extends Thread {
        BatchBufferActivityCheckerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                String string = "";
                try {
                    long l = System.currentTimeMillis();
                    if (l - SplunkHECInput.this.lastEventReceivedTime >= SplunkHECInput.this.config.getMaxInactiveTimeBeforeBatchFlush() && SplunkHECInput.this.batchBuffer.size() > 0) {
                        List list = SplunkHECInput.this.batchBuffer;
                        synchronized (list) {
                            string = SplunkHECInput.this.rollOutBatchBuffer();
                            SplunkHECInput.this.batchBuffer.clear();
                            SplunkHECInput.this.currentBatchSizeBytes = 0L;
                        }
                        SplunkHECInput.this.hecPost(string);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    SplunkHECInput.this.enqueue(string);
                    try {
                        SplunkHECInput.this.closeStream();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        SplunkHECInput.this.openStream();
                    }
                    catch (Exception exception3) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

