/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.log4j2.appender;

import com.splunk.logging.HECTransportConfig;
import com.splunk.logging.SplunkHECInput;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="SplunkHECAppender", category="Core", elementType="appender", printObject=true)
public final class SplunkHECAppender
extends AbstractAppender {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private HECTransportConfig config;
    private String maxQueueSize;
    private boolean dropEventsOnQueueFull;
    private SplunkHECInput shi;
    private String activationKey;

    protected SplunkHECAppender(String string, HECTransportConfig hECTransportConfig, boolean bl, String string2, Filter filter, Layout<? extends Serializable> layout, boolean bl2, String string3) {
        super(string, filter, layout, bl2);
        this.config = hECTransportConfig;
        this.activationKey = string3;
        try {
            this.shi = new SplunkHECInput(hECTransportConfig, this.activationKey);
            this.shi.setMaxQueueSize(string2);
            this.shi.setDropEventsOnQueueFull(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent logEvent) {
        this.readLock.lock();
        try {
            try {
                if (this.shi == null) {
                    this.shi = new SplunkHECInput(this.config, this.activationKey);
                    this.shi.setMaxQueueSize(this.maxQueueSize);
                    this.shi.setDropEventsOnQueueFull(this.dropEventsOnQueueFull);
                }
            }
            catch (Exception exception) {
                throw new AppenderLoggingException("Couldn't establish connection for SplunkHECAppender named \"" + this.getName() + "\".");
            }
            byte[] byArray = this.getLayout().toByteArray(logEvent);
            String string = new String(byArray);
            this.shi.streamEvent(string);
        }
        catch (Exception exception) {
            if (!this.ignoreExceptions()) {
                throw new AppenderLoggingException((Throwable)exception);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @PluginFactory
    public static SplunkHECAppender createAppender(@PluginAttribute(value="name") String string, @PluginElement(value="Layout") Layout<? extends Serializable> patternLayout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="token") String string2, @PluginAttribute(value="activationKey") String string3, @PluginAttribute(value="host") String string4, @PluginAttribute(value="port") int n, @PluginAttribute(value="poolsize") int n2, @PluginAttribute(value="https") boolean bl, @PluginAttribute(value="index") String string5, @PluginAttribute(value="source") String string6, @PluginAttribute(value="sourcetype") String string7, @PluginAttribute(value="maxQueueSize") String string8, @PluginAttribute(value="dropEventsOnQueueFull") boolean bl2, @PluginAttribute(value="batchMode") boolean bl3, @PluginAttribute(value="maxBatchSizeBytes") String string9, @PluginAttribute(value="maxBatchSizeEvents") long l, @PluginAttribute(value="maxInactiveTimeBeforeBatchFlush") long l2) {
        if (string == null) {
            LOGGER.error("No name provided for SplunkHECAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        HECTransportConfig hECTransportConfig = new HECTransportConfig();
        if (string2 == null) {
            LOGGER.error("No token provided for SplunkHECAppender");
            return null;
        }
        hECTransportConfig.setHost(string4);
        hECTransportConfig.setPort(n);
        hECTransportConfig.setToken(string2);
        hECTransportConfig.setPoolsize(n2);
        hECTransportConfig.setHttps(bl);
        hECTransportConfig.setIndex(string5);
        hECTransportConfig.setSource(string6);
        hECTransportConfig.setSourcetype(string7);
        hECTransportConfig.setBatchMode(bl3);
        hECTransportConfig.setMaxBatchSizeBytes(string9);
        hECTransportConfig.setMaxBatchSizeEvents(l);
        hECTransportConfig.setMaxInactiveTimeBeforeBatchFlush(l2);
        return new SplunkHECAppender(string, hECTransportConfig, bl2, string8, filter, (Layout<? extends Serializable>)patternLayout, true, string3);
    }
}

