/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public abstract class SplunkInput {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private long maxQueueSize = 512000L;
    private boolean dropEventsOnQueueFull = false;
    private List<String> queue = new ArrayList<String>();
    private long currentQueueSizeInBytes = 0L;
    protected boolean activated = false;

    protected void enqueue(String string) {
        long l = string.getBytes().length;
        if (this.queueHasCapacity(l)) {
            this.queue.add(string);
            this.currentQueueSizeInBytes += l;
        } else if (this.dropEventsOnQueueFull) {
            this.queue.clear();
            this.queue.add(string);
            this.currentQueueSizeInBytes = l;
        }
    }

    private boolean queueHasCapacity(long l) {
        return this.currentQueueSizeInBytes + l <= this.maxQueueSize;
    }

    protected boolean queueContainsEvents() {
        return !this.queue.isEmpty();
    }

    protected String dequeue() {
        if (this.queueContainsEvents()) {
            String string = this.queue.remove(0);
            this.currentQueueSizeInBytes -= (long)string.getBytes().length;
            if (this.currentQueueSizeInBytes < 0L) {
                this.currentQueueSizeInBytes = 0L;
            }
            return string;
        }
        return null;
    }

    public void setMaxQueueSize(String string) {
        int n;
        int n2;
        if (string.endsWith("KB")) {
            n2 = 1024;
        } else if (string.endsWith("MB")) {
            n2 = 0x100000;
        } else if (string.endsWith("GB")) {
            n2 = 0x40000000;
        } else {
            return;
        }
        try {
            n = Integer.parseInt(string.substring(0, string.length() - 2));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.setMaxQueueSize(n * n2);
    }

    public long getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(long l) {
        this.maxQueueSize = l;
    }

    public boolean isDropEventsOnQueueFull() {
        return this.dropEventsOnQueueFull;
    }

    public void setDropEventsOnQueueFull(boolean bl) {
        this.dropEventsOnQueueFull = bl;
    }

    protected void activationKeyCheck(String string) {
        try {
            String string2 = "Java Logging Appenders";
            string = string.trim();
            if (string.length() > 32) {
                byte[] byArray;
                String string3 = string.substring(0, 32);
                String string4 = this.barbraStreisand(string.substring(32));
                long l = System.currentTimeMillis() / 1000L;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray2 = messageDigest.digest((string2 + string4).getBytes());
                this.activated = !MessageDigest.isEqual(byArray2, byArray = DatatypeConverter.parseHexBinary((String)string3)) ? false : l - Long.parseLong(string4) <= 604800L;
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = DatatypeConverter.parseHexBinary((String)string);
                byte[] byArray3 = messageDigest.digest(string2.getBytes());
                this.activated = MessageDigest.isEqual(byArray3, byArray);
            }
        }
        catch (Throwable throwable) {
            this.activated = false;
        }
    }

    protected String barbraStreisand(String string) {
        return new StringBuilder(string).reverse().toString();
    }
}

