/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.ResponseMessage;
import com.splunk.Xml;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HttpException
extends RuntimeException {
    private int status;
    private String detail;

    HttpException(int status, String message, String detail) {
        super(message);
        this.status = status;
        this.detail = detail;
    }

    static HttpException create(ResponseMessage response) {
        InputStreamReader r;
        int status = response.getStatus();
        StringBuilder s = new StringBuilder();
        try {
            r = new InputStreamReader(response.getContent(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new AssertionError((Object)"How does your system not support UTF-8?");
        }
        int c = -1;
        while (true) {
            try {
                c = r.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (c == -1) break;
            s.appendCodePoint(c);
        }
        String detail = "";
        try {
            Document document = Xml.parse(new ByteArrayInputStream(detail.getBytes()));
            NodeList msgs = document.getElementsByTagName("msg");
            if (msgs.getLength() > 0) {
                detail = msgs.item(0).getTextContent();
            }
        }
        catch (Exception e) {
            detail = s.toString();
        }
        String message = String.format("HTTP %d", status);
        if (detail != null && detail.length() > 0) {
            message = String.valueOf(message) + " -- " + detail;
        }
        return new HttpException(status, message, detail);
    }

    public String getDetail() {
        return this.detail;
    }

    public int getStatus() {
        return this.status;
    }
}

