/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.InputKind;
import com.splunk.PortInput;
import com.splunk.Service;
import com.splunk.UdpConnections;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UdpInput
extends PortInput {
    UdpInput(Service service, String path) {
        super(service, path);
    }

    public UdpConnections connections() {
        return new UdpConnections(this.service, String.valueOf(this.path) + "/connections");
    }

    public String getConnectionHost() {
        return this.getString("connection_host", null);
    }

    public String getGroup() {
        return this.getString("group");
    }

    public String getHost() {
        return this.getString("host");
    }

    public String getIndex() {
        return this.getString("index");
    }

    @Override
    public InputKind getKind() {
        return InputKind.Udp;
    }

    public String getQueue() {
        return this.getString("queue", null);
    }

    public int getRcvBuf() {
        return this.getInteger("_rcvbuf");
    }

    public String getSource() {
        return this.getString("source", null);
    }

    public String getSourceType() {
        return this.getString("sourcetype", null);
    }

    public boolean getNoAppendingTimeStamp() {
        return this.getBoolean("no_appending_timestamp", false);
    }

    public boolean getNoPriorityStripping() {
        return this.getBoolean("no_priority_stripping", false);
    }

    public void setConnectionHost(String connection_host) {
        this.setCacheValue("connection_host", connection_host);
    }

    public void setHost(String host) {
        this.setCacheValue("host", host);
    }

    public void setIndex(String index) {
        this.setCacheValue("index", index);
    }

    public void setNoAppendingTimeStamp(boolean no_appending_timestamp) {
        this.setCacheValue("no_appending_timestamp", no_appending_timestamp);
    }

    public void setNoPriorityStripping(boolean no_priority_stripping) {
        this.setCacheValue("no_priority_stripping", no_priority_stripping);
    }

    public void setQueue(String queue) {
        this.setCacheValue("queue", queue);
    }

    public void setSource(String source) {
        this.setCacheValue("source", source);
    }

    public void setSourceType(String sourcetype) {
        this.setCacheValue("sourcetype", sourcetype);
    }

    public void submit(String eventBody) throws IOException {
        DatagramSocket socket = new DatagramSocket();
        InetAddress address = InetAddress.getByName(this.service.getHost());
        int port = this.getPort();
        byte[] buffer = eventBody.getBytes("UTF-8");
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, port);
        socket.send(packet);
        socket.close();
    }
}

